package com.xforceplus.financialsettlement.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2022-06-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ProjectInfoUnderContract implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 项目分期名称
   */
  @TableField("projectStageName")
  private String projectStageName;

  /**
   * 项目编号
   */
  @TableField("projectStageNo")
  private String projectStageNo;

  /**
   * 产品名称
   */
  @TableField("productName")
  private String productName;

  /**
   * 产品编号
   */
  @TableField("productCode")
  private String productCode;

  /**
   * 项目阶段
   */
  @TableField("projectStage")
  private String projectStage;

  /**
   * 项目阶段状态
   */
  @TableField("projectStageStatus")
  private String projectStageStatus;

  /**
   * 验收状态
   */
  @TableField("receptionStatus")
  private String receptionStatus;

  /**
   * 验收交付物
   */
  @TableField("receptionDeliverables")
  private String receptionDeliverables;

  /**
   * 项目经理
   */
  @TableField("projectManager")
  private String projectManager;

  /**
   * 项目创建时间
   */
  @TableField("projectCreateTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime projectCreateTime;

  /**
   * 项目阶段完成时间
   */
  @TableField("projectStageFinishTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime projectStageFinishTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("projectStageName", projectStageName);
      map.put("projectStageNo", projectStageNo);
      map.put("productName", productName);
      map.put("productCode", productCode);
      map.put("projectStage", projectStage);
      map.put("projectStageStatus", projectStageStatus);
      map.put("receptionStatus", receptionStatus);
      map.put("receptionDeliverables", receptionDeliverables);
      map.put("projectManager", projectManager);
      map.put("projectCreateTime", BocpGenUtils.toTimestamp(projectCreateTime));
      map.put("projectStageFinishTime", BocpGenUtils.toTimestamp(projectStageFinishTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static ProjectInfoUnderContract fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ProjectInfoUnderContract entity = new ProjectInfoUnderContract();
    if(map.containsKey("projectStageName")) {
      Object obj = map.get("projectStageName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectStageName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStageNo")) {
      Object obj = map.get("projectStageNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectStageNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productName")) {
      Object obj = map.get("productName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCode")) {
      Object obj = map.get("productCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStage")) {
      Object obj = map.get("projectStage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectStage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectStageStatus")) {
      Object obj = map.get("projectStageStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectStageStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receptionStatus")) {
      Object obj = map.get("receptionStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receptionDeliverables")) {
      Object obj = map.get("receptionDeliverables");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceptionDeliverables((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectManager")) {
      Object obj = map.get("projectManager");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectManager((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectCreateTime")) {
      Object obj = map.get("projectCreateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProjectCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setProjectCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setProjectCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProjectCreateTime(null);
      }
    }
    if(map.containsKey("projectStageFinishTime")) {
      Object obj = map.get("projectStageFinishTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setProjectStageFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setProjectStageFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setProjectStageFinishTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
