package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ProductFunction;
import com.xforceplus.financialsettlement.service.IProductFunctionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-27
 */
@RestController
public class ProductFunctionController {

  @Autowired
  private IProductFunctionService productFunctionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productFunction ${table.comment}
   * @return
   */
  @GetMapping("/productfunctions" )
  public XfR getProductFunctions(XfPage page, ProductFunction productFunction) {
    return XfR.ok(productFunctionServiceImpl.page(page, Wrappers.query(productFunction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/productfunctions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productFunctionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param productFunction ${table.comment}
   * @return XfR
   */
  @PostMapping("/productfunctions")
  public XfR save(@RequestBody ProductFunction productFunction) {
     return XfR.ok(productFunctionServiceImpl.save(productFunction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param productFunction ${table.comment}
   * @return XfR
   */
  @PutMapping("/productfunctions/{id}")
  public XfR putUpdate(@RequestBody ProductFunction productFunction,@PathVariable Long id) {
      productFunction.setId(id);
      return XfR.ok(productFunctionServiceImpl.updateById(productFunction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param productFunction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/productfunctions/{id}")
  public XfR patchUpdate(@RequestBody ProductFunction productFunction,@PathVariable Long id) {
      ProductFunction upproductFunction = productFunctionServiceImpl.getById(id);
      if(upproductFunction != null){
        upproductFunction = ObjectCopyUtils.copyProperties(productFunction,upproductFunction,true);
      }
      return XfR.ok(productFunctionServiceImpl.updateById(upproductFunction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productfunctions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productFunctionServiceImpl.removeById(id));
  }

  @PostMapping("/productfunctions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_function");
     params.put("request", condition);

     return XfR.ok(productFunctionServiceImpl.querys(params));
  }

}
