package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.IncomeDetail;
import com.xforceplus.financialsettlement.service.IIncomeDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-30
 */
@RestController
public class IncomeDetailController {

  @Autowired
  private IIncomeDetailService incomeDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param incomeDetail ${table.comment}
   * @return
   */
  @GetMapping("/incomedetails" )
  public XfR getIncomeDetails(XfPage page, IncomeDetail incomeDetail) {
    return XfR.ok(incomeDetailServiceImpl.page(page, Wrappers.query(incomeDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param incomeDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/incomedetails")
  public XfR save(@RequestBody IncomeDetail incomeDetail) {
     return XfR.ok(incomeDetailServiceImpl.save(incomeDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param incomeDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/incomedetails/{id}")
  public XfR putUpdate(@RequestBody IncomeDetail incomeDetail,@PathVariable Long id) {
      incomeDetail.setId(id);
      return XfR.ok(incomeDetailServiceImpl.updateById(incomeDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param incomeDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/incomedetails/{id}")
  public XfR patchUpdate(@RequestBody IncomeDetail incomeDetail,@PathVariable Long id) {
      IncomeDetail upincomeDetail = incomeDetailServiceImpl.getById(id);
      if(upincomeDetail != null){
        upincomeDetail = ObjectCopyUtils.copyProperties(incomeDetail,upincomeDetail,true);
      }
      return XfR.ok(incomeDetailServiceImpl.updateById(upincomeDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeDetailServiceImpl.removeById(id));
  }

  @PostMapping("/incomedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income_detail");
     params.put("request", condition);

     return XfR.ok(incomeDetailServiceImpl.querys(params));
  }

}
