package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.SettlementMainData;
import com.xforceplus.financialsettlement.service.ISettlementMainDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-30
 */
@RestController
public class SettlementMainDataController {

  @Autowired
  private ISettlementMainDataService settlementMainDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementMainData ${table.comment}
   * @return
   */
  @GetMapping("/settlementmaindatas" )
  public XfR getSettlementMainDatas(XfPage page, SettlementMainData settlementMainData) {
    return XfR.ok(settlementMainDataServiceImpl.page(page, Wrappers.query(settlementMainData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementmaindatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementMainDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementMainData ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementmaindatas")
  public XfR save(@RequestBody SettlementMainData settlementMainData) {
     return XfR.ok(settlementMainDataServiceImpl.save(settlementMainData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementMainData ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementmaindatas/{id}")
  public XfR putUpdate(@RequestBody SettlementMainData settlementMainData,@PathVariable Long id) {
      settlementMainData.setId(id);
      return XfR.ok(settlementMainDataServiceImpl.updateById(settlementMainData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementMainData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementmaindatas/{id}")
  public XfR patchUpdate(@RequestBody SettlementMainData settlementMainData,@PathVariable Long id) {
      SettlementMainData upsettlementMainData = settlementMainDataServiceImpl.getById(id);
      if(upsettlementMainData != null){
        upsettlementMainData = ObjectCopyUtils.copyProperties(settlementMainData,upsettlementMainData,true);
      }
      return XfR.ok(settlementMainDataServiceImpl.updateById(upsettlementMainData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementmaindatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementMainDataServiceImpl.removeById(id));
  }

  @PostMapping("/settlementmaindatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_main_data");
     params.put("request", condition);

     return XfR.ok(settlementMainDataServiceImpl.querys(params));
  }

}
