package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.UnitPrice;
import com.xforceplus.financialsettlement.service.IUnitPriceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-30
 */
@RestController
public class UnitPriceController {

  @Autowired
  private IUnitPriceService unitPriceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param unitPrice ${table.comment}
   * @return
   */
  @GetMapping("/unitprices" )
  public XfR getUnitPrices(XfPage page, UnitPrice unitPrice) {
    return XfR.ok(unitPriceServiceImpl.page(page, Wrappers.query(unitPrice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/unitprices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(unitPriceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param unitPrice ${table.comment}
   * @return XfR
   */
  @PostMapping("/unitprices")
  public XfR save(@RequestBody UnitPrice unitPrice) {
     return XfR.ok(unitPriceServiceImpl.save(unitPrice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param unitPrice ${table.comment}
   * @return XfR
   */
  @PutMapping("/unitprices/{id}")
  public XfR putUpdate(@RequestBody UnitPrice unitPrice,@PathVariable Long id) {
      unitPrice.setId(id);
      return XfR.ok(unitPriceServiceImpl.updateById(unitPrice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param unitPrice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/unitprices/{id}")
  public XfR patchUpdate(@RequestBody UnitPrice unitPrice,@PathVariable Long id) {
      UnitPrice upunitPrice = unitPriceServiceImpl.getById(id);
      if(upunitPrice != null){
        upunitPrice = ObjectCopyUtils.copyProperties(unitPrice,upunitPrice,true);
      }
      return XfR.ok(unitPriceServiceImpl.updateById(upunitPrice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/unitprices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(unitPriceServiceImpl.removeById(id));
  }

  @PostMapping("/unitprices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "unit_price");
     params.put("request", condition);

     return XfR.ok(unitPriceServiceImpl.querys(params));
  }

}
