package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReturnMoneyNoNeed;
import com.xforceplus.financialsettlement.service.IReturnMoneyNoNeedService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 回款-无需认领前端控制器
 *
 * @author ultraman
 * @date 2021-11-17
 */
@RestController
public class ReturnMoneyNoNeedController {

  @Autowired
  private IReturnMoneyNoNeedService returnMoneyNoNeedServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnMoneyNoNeed 回款-无需认领
   * @return
   */
  @GetMapping("/returnmoneynoneeds" )
  public XfR getReturnMoneyNoNeeds(XfPage page, ReturnMoneyNoNeed returnMoneyNoNeed) {
    return XfR.ok(returnMoneyNoNeedServiceImpl.page(page, Wrappers.query(returnMoneyNoNeed)));
  }

  /**
   * 通过id查询回款-无需认领
   * @param  id
   * @return XfR
   */
  @GetMapping("/returnmoneynoneeds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnMoneyNoNeedServiceImpl.getById(id));
  }

  /**
   * 新增回款-无需认领
   * @param returnMoneyNoNeed 回款-无需认领
   * @return XfR
   */
  @PostMapping("/returnmoneynoneeds")
  public XfR save(@RequestBody ReturnMoneyNoNeed returnMoneyNoNeed) {
     return XfR.ok(returnMoneyNoNeedServiceImpl.save(returnMoneyNoNeed));
  }

  /**
   * 修改-传入修改后的全部数据回款-无需认领
   * @param returnMoneyNoNeed 回款-无需认领
   * @return XfR
   */
  @PutMapping("/returnmoneynoneeds/{id}")
  public XfR putUpdate(@RequestBody ReturnMoneyNoNeed returnMoneyNoNeed,@PathVariable Long id) {
      returnMoneyNoNeed.setId(id);
      return XfR.ok(returnMoneyNoNeedServiceImpl.updateById(returnMoneyNoNeed));
  }

  /**
   * 修改-传入修改的数据回款-无需认领
   * @param returnMoneyNoNeed 回款-无需认领
   * @return XfR
   */
  @PatchMapping("/returnmoneynoneeds/{id}")
  public XfR patchUpdate(@RequestBody ReturnMoneyNoNeed returnMoneyNoNeed,@PathVariable Long id) {
      ReturnMoneyNoNeed upreturnMoneyNoNeed = returnMoneyNoNeedServiceImpl.getById(id);
      if(upreturnMoneyNoNeed != null){
        upreturnMoneyNoNeed = ObjectCopyUtils.copyProperties(returnMoneyNoNeed,upreturnMoneyNoNeed,true);
      }
      return XfR.ok(returnMoneyNoNeedServiceImpl.updateById(upreturnMoneyNoNeed));
  }

  /**
   * 通过id删除回款-无需认领
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returnmoneynoneeds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnMoneyNoNeedServiceImpl.removeById(id));
  }

  @PostMapping("/returnmoneynoneeds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_money_no_need");
     params.put("request", condition);

     return XfR.ok(returnMoneyNoNeedServiceImpl.querys(params));
  }

}
