package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReturnMoneyNotTaken;
import com.xforceplus.financialsettlement.service.IReturnMoneyNotTakenService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 回款-未认领前端控制器
 *
 * @author ultraman
 * @date 2021-11-17
 */
@RestController
public class ReturnMoneyNotTakenController {

  @Autowired
  private IReturnMoneyNotTakenService returnMoneyNotTakenServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnMoneyNotTaken 回款-未认领
   * @return
   */
  @GetMapping("/returnmoneynottakens" )
  public XfR getReturnMoneyNotTakens(XfPage page, ReturnMoneyNotTaken returnMoneyNotTaken) {
    return XfR.ok(returnMoneyNotTakenServiceImpl.page(page, Wrappers.query(returnMoneyNotTaken)));
  }

  /**
   * 通过id查询回款-未认领
   * @param  id
   * @return XfR
   */
  @GetMapping("/returnmoneynottakens/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnMoneyNotTakenServiceImpl.getById(id));
  }

  /**
   * 新增回款-未认领
   * @param returnMoneyNotTaken 回款-未认领
   * @return XfR
   */
  @PostMapping("/returnmoneynottakens")
  public XfR save(@RequestBody ReturnMoneyNotTaken returnMoneyNotTaken) {
     return XfR.ok(returnMoneyNotTakenServiceImpl.save(returnMoneyNotTaken));
  }

  /**
   * 修改-传入修改后的全部数据回款-未认领
   * @param returnMoneyNotTaken 回款-未认领
   * @return XfR
   */
  @PutMapping("/returnmoneynottakens/{id}")
  public XfR putUpdate(@RequestBody ReturnMoneyNotTaken returnMoneyNotTaken,@PathVariable Long id) {
      returnMoneyNotTaken.setId(id);
      return XfR.ok(returnMoneyNotTakenServiceImpl.updateById(returnMoneyNotTaken));
  }

  /**
   * 修改-传入修改的数据回款-未认领
   * @param returnMoneyNotTaken 回款-未认领
   * @return XfR
   */
  @PatchMapping("/returnmoneynottakens/{id}")
  public XfR patchUpdate(@RequestBody ReturnMoneyNotTaken returnMoneyNotTaken,@PathVariable Long id) {
      ReturnMoneyNotTaken upreturnMoneyNotTaken = returnMoneyNotTakenServiceImpl.getById(id);
      if(upreturnMoneyNotTaken != null){
        upreturnMoneyNotTaken = ObjectCopyUtils.copyProperties(returnMoneyNotTaken,upreturnMoneyNotTaken,true);
      }
      return XfR.ok(returnMoneyNotTakenServiceImpl.updateById(upreturnMoneyNotTaken));
  }

  /**
   * 通过id删除回款-未认领
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returnmoneynottakens/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnMoneyNotTakenServiceImpl.removeById(id));
  }

  @PostMapping("/returnmoneynottakens/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_money_not_taken");
     params.put("request", condition);

     return XfR.ok(returnMoneyNotTakenServiceImpl.querys(params));
  }

}
