package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReturnMoneyTaken;
import com.xforceplus.financialsettlement.service.IReturnMoneyTakenService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 回款-已认领前端控制器
 *
 * @author ultraman
 * @date 2021-11-17
 */
@RestController
public class ReturnMoneyTakenController {

  @Autowired
  private IReturnMoneyTakenService returnMoneyTakenServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param returnMoneyTaken 回款-已认领
   * @return
   */
  @GetMapping("/returnmoneytakens" )
  public XfR getReturnMoneyTakens(XfPage page, ReturnMoneyTaken returnMoneyTaken) {
    return XfR.ok(returnMoneyTakenServiceImpl.page(page, Wrappers.query(returnMoneyTaken)));
  }

  /**
   * 通过id查询回款-已认领
   * @param  id
   * @return XfR
   */
  @GetMapping("/returnmoneytakens/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(returnMoneyTakenServiceImpl.getById(id));
  }

  /**
   * 新增回款-已认领
   * @param returnMoneyTaken 回款-已认领
   * @return XfR
   */
  @PostMapping("/returnmoneytakens")
  public XfR save(@RequestBody ReturnMoneyTaken returnMoneyTaken) {
     return XfR.ok(returnMoneyTakenServiceImpl.save(returnMoneyTaken));
  }

  /**
   * 修改-传入修改后的全部数据回款-已认领
   * @param returnMoneyTaken 回款-已认领
   * @return XfR
   */
  @PutMapping("/returnmoneytakens/{id}")
  public XfR putUpdate(@RequestBody ReturnMoneyTaken returnMoneyTaken,@PathVariable Long id) {
      returnMoneyTaken.setId(id);
      return XfR.ok(returnMoneyTakenServiceImpl.updateById(returnMoneyTaken));
  }

  /**
   * 修改-传入修改的数据回款-已认领
   * @param returnMoneyTaken 回款-已认领
   * @return XfR
   */
  @PatchMapping("/returnmoneytakens/{id}")
  public XfR patchUpdate(@RequestBody ReturnMoneyTaken returnMoneyTaken,@PathVariable Long id) {
      ReturnMoneyTaken upreturnMoneyTaken = returnMoneyTakenServiceImpl.getById(id);
      if(upreturnMoneyTaken != null){
        upreturnMoneyTaken = ObjectCopyUtils.copyProperties(returnMoneyTaken,upreturnMoneyTaken,true);
      }
      return XfR.ok(returnMoneyTakenServiceImpl.updateById(upreturnMoneyTaken));
  }

  /**
   * 通过id删除回款-已认领
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/returnmoneytakens/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(returnMoneyTakenServiceImpl.removeById(id));
  }

  @PostMapping("/returnmoneytakens/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "return_money_taken");
     params.put("request", condition);

     return XfR.ok(returnMoneyTakenServiceImpl.querys(params));
  }

}
