package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ContractRawData;
import com.xforceplus.financialsettlement.service.IContractRawDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 合同裸数据前端控制器
 *
 * @author ultraman
 * @date 2021-11-18
 */
@RestController
public class ContractRawDataController {

  @Autowired
  private IContractRawDataService contractRawDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param contractRawData 合同裸数据
   * @return
   */
  @GetMapping("/contractrawdatas" )
  public XfR getContractRawDatas(XfPage page, ContractRawData contractRawData) {
    return XfR.ok(contractRawDataServiceImpl.page(page, Wrappers.query(contractRawData)));
  }

  /**
   * 通过id查询合同裸数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/contractrawdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(contractRawDataServiceImpl.getById(id));
  }

  /**
   * 新增合同裸数据
   * @param contractRawData 合同裸数据
   * @return XfR
   */
  @PostMapping("/contractrawdatas")
  public XfR save(@RequestBody ContractRawData contractRawData) {
     return XfR.ok(contractRawDataServiceImpl.save(contractRawData));
  }

  /**
   * 修改-传入修改后的全部数据合同裸数据
   * @param contractRawData 合同裸数据
   * @return XfR
   */
  @PutMapping("/contractrawdatas/{id}")
  public XfR putUpdate(@RequestBody ContractRawData contractRawData,@PathVariable Long id) {
      contractRawData.setId(id);
      return XfR.ok(contractRawDataServiceImpl.updateById(contractRawData));
  }

  /**
   * 修改-传入修改的数据合同裸数据
   * @param contractRawData 合同裸数据
   * @return XfR
   */
  @PatchMapping("/contractrawdatas/{id}")
  public XfR patchUpdate(@RequestBody ContractRawData contractRawData,@PathVariable Long id) {
      ContractRawData upcontractRawData = contractRawDataServiceImpl.getById(id);
      if(upcontractRawData != null){
        upcontractRawData = ObjectCopyUtils.copyProperties(contractRawData,upcontractRawData,true);
      }
      return XfR.ok(contractRawDataServiceImpl.updateById(upcontractRawData));
  }

  /**
   * 通过id删除合同裸数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/contractrawdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(contractRawDataServiceImpl.removeById(id));
  }

  @PostMapping("/contractrawdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "contract_raw_data");
     params.put("request", condition);

     return XfR.ok(contractRawDataServiceImpl.querys(params));
  }

}
