package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Member;
import com.xforceplus.financialsettlement.service.IMemberService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 人员基础信息前端控制器
 *
 * @author ultraman
 * @date 2021-11-18
 */
@RestController
public class MemberController {

  @Autowired
  private IMemberService memberServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param member 人员基础信息
   * @return
   */
  @GetMapping("/members" )
  public XfR getMembers(XfPage page, Member member) {
    return XfR.ok(memberServiceImpl.page(page, Wrappers.query(member)));
  }

  /**
   * 通过id查询人员基础信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/members/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(memberServiceImpl.getById(id));
  }

  /**
   * 新增人员基础信息
   * @param member 人员基础信息
   * @return XfR
   */
  @PostMapping("/members")
  public XfR save(@RequestBody Member member) {
     return XfR.ok(memberServiceImpl.save(member));
  }

  /**
   * 修改-传入修改后的全部数据人员基础信息
   * @param member 人员基础信息
   * @return XfR
   */
  @PutMapping("/members/{id}")
  public XfR putUpdate(@RequestBody Member member,@PathVariable Long id) {
      member.setId(id);
      return XfR.ok(memberServiceImpl.updateById(member));
  }

  /**
   * 修改-传入修改的数据人员基础信息
   * @param member 人员基础信息
   * @return XfR
   */
  @PatchMapping("/members/{id}")
  public XfR patchUpdate(@RequestBody Member member,@PathVariable Long id) {
      Member upmember = memberServiceImpl.getById(id);
      if(upmember != null){
        upmember = ObjectCopyUtils.copyProperties(member,upmember,true);
      }
      return XfR.ok(memberServiceImpl.updateById(upmember));
  }

  /**
   * 通过id删除人员基础信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/members/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(memberServiceImpl.removeById(id));
  }

  @PostMapping("/members/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "member");
     params.put("request", condition);

     return XfR.ok(memberServiceImpl.querys(params));
  }

}
