package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderNo;
import com.xforceplus.financialsettlement.service.IOrderNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 订单前端控制器
 *
 * @author ultraman
 * @date 2021-11-18
 */
@RestController
public class OrderNoController {

  @Autowired
  private IOrderNoService orderNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderNo 订单
   * @return
   */
  @GetMapping("/ordernos" )
  public XfR getOrderNos(XfPage page, OrderNo orderNo) {
    return XfR.ok(orderNoServiceImpl.page(page, Wrappers.query(orderNo)));
  }

  /**
   * 通过id查询订单
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordernos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderNoServiceImpl.getById(id));
  }

  /**
   * 新增订单
   * @param orderNo 订单
   * @return XfR
   */
  @PostMapping("/ordernos")
  public XfR save(@RequestBody OrderNo orderNo) {
     return XfR.ok(orderNoServiceImpl.save(orderNo));
  }

  /**
   * 修改-传入修改后的全部数据订单
   * @param orderNo 订单
   * @return XfR
   */
  @PutMapping("/ordernos/{id}")
  public XfR putUpdate(@RequestBody OrderNo orderNo,@PathVariable Long id) {
      orderNo.setId(id);
      return XfR.ok(orderNoServiceImpl.updateById(orderNo));
  }

  /**
   * 修改-传入修改的数据订单
   * @param orderNo 订单
   * @return XfR
   */
  @PatchMapping("/ordernos/{id}")
  public XfR patchUpdate(@RequestBody OrderNo orderNo,@PathVariable Long id) {
      OrderNo uporderNo = orderNoServiceImpl.getById(id);
      if(uporderNo != null){
        uporderNo = ObjectCopyUtils.copyProperties(orderNo,uporderNo,true);
      }
      return XfR.ok(orderNoServiceImpl.updateById(uporderNo));
  }

  /**
   * 通过id删除订单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordernos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderNoServiceImpl.removeById(id));
  }

  @PostMapping("/ordernos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_no");
     params.put("request", condition);

     return XfR.ok(orderNoServiceImpl.querys(params));
  }

}
