package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeMetaData;
import com.xforceplus.financialsettlement.service.IChargeMetaDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 计费元数据前端控制器
 *
 * @author ultraman
 * @date 2021-12-03
 */
@RestController
public class ChargeMetaDataController {

  @Autowired
  private IChargeMetaDataService chargeMetaDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeMetaData 计费元数据
   * @return
   */
  @GetMapping("/chargemetadatas" )
  public XfR getChargeMetaDatas(XfPage page, ChargeMetaData chargeMetaData) {
    return XfR.ok(chargeMetaDataServiceImpl.page(page, Wrappers.query(chargeMetaData)));
  }

  /**
   * 通过id查询计费元数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargemetadatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeMetaDataServiceImpl.getById(id));
  }

  /**
   * 新增计费元数据
   * @param chargeMetaData 计费元数据
   * @return XfR
   */
  @PostMapping("/chargemetadatas")
  public XfR save(@RequestBody ChargeMetaData chargeMetaData) {
     return XfR.ok(chargeMetaDataServiceImpl.save(chargeMetaData));
  }

  /**
   * 修改-传入修改后的全部数据计费元数据
   * @param chargeMetaData 计费元数据
   * @return XfR
   */
  @PutMapping("/chargemetadatas/{id}")
  public XfR putUpdate(@RequestBody ChargeMetaData chargeMetaData,@PathVariable Long id) {
      chargeMetaData.setId(id);
      return XfR.ok(chargeMetaDataServiceImpl.updateById(chargeMetaData));
  }

  /**
   * 修改-传入修改的数据计费元数据
   * @param chargeMetaData 计费元数据
   * @return XfR
   */
  @PatchMapping("/chargemetadatas/{id}")
  public XfR patchUpdate(@RequestBody ChargeMetaData chargeMetaData,@PathVariable Long id) {
      ChargeMetaData upchargeMetaData = chargeMetaDataServiceImpl.getById(id);
      if(upchargeMetaData != null){
        upchargeMetaData = ObjectCopyUtils.copyProperties(chargeMetaData,upchargeMetaData,true);
      }
      return XfR.ok(chargeMetaDataServiceImpl.updateById(upchargeMetaData));
  }

  /**
   * 通过id删除计费元数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargemetadatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeMetaDataServiceImpl.removeById(id));
  }

  @PostMapping("/chargemetadatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_meta_data");
     params.put("request", condition);

     return XfR.ok(chargeMetaDataServiceImpl.querys(params));
  }

}
