package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CapitalJournal;
import com.xforceplus.financialsettlement.service.ICapitalJournalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class CapitalJournalController {

  @Autowired
  private ICapitalJournalService capitalJournalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param capitalJournal ${table.comment}
   * @return
   */
  @GetMapping("/capitaljournals" )
  public XfR getCapitalJournals(XfPage page, CapitalJournal capitalJournal) {
    return XfR.ok(capitalJournalServiceImpl.page(page, Wrappers.query(capitalJournal)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/capitaljournals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(capitalJournalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param capitalJournal ${table.comment}
   * @return XfR
   */
  @PostMapping("/capitaljournals")
  public XfR save(@RequestBody CapitalJournal capitalJournal) {
     return XfR.ok(capitalJournalServiceImpl.save(capitalJournal));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param capitalJournal ${table.comment}
   * @return XfR
   */
  @PutMapping("/capitaljournals/{id}")
  public XfR putUpdate(@RequestBody CapitalJournal capitalJournal,@PathVariable Long id) {
      capitalJournal.setId(id);
      return XfR.ok(capitalJournalServiceImpl.updateById(capitalJournal));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param capitalJournal ${table.comment}
   * @return XfR
   */
  @PatchMapping("/capitaljournals/{id}")
  public XfR patchUpdate(@RequestBody CapitalJournal capitalJournal,@PathVariable Long id) {
      CapitalJournal upcapitalJournal = capitalJournalServiceImpl.getById(id);
      if(upcapitalJournal != null){
        upcapitalJournal = ObjectCopyUtils.copyProperties(capitalJournal,upcapitalJournal,true);
      }
      return XfR.ok(capitalJournalServiceImpl.updateById(upcapitalJournal));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/capitaljournals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(capitalJournalServiceImpl.removeById(id));
  }

  @PostMapping("/capitaljournals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "capital_journal");
     params.put("request", condition);

     return XfR.ok(capitalJournalServiceImpl.querys(params));
  }

}
