package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReconcilationData;
import com.xforceplus.financialsettlement.service.IReconcilationDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ReconcilationDataController {

  @Autowired
  private IReconcilationDataService reconcilationDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reconcilationData ${table.comment}
   * @return
   */
  @GetMapping("/reconcilationdatas" )
  public XfR getReconcilationDatas(XfPage page, ReconcilationData reconcilationData) {
    return XfR.ok(reconcilationDataServiceImpl.page(page, Wrappers.query(reconcilationData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reconcilationdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reconcilationDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reconcilationData ${table.comment}
   * @return XfR
   */
  @PostMapping("/reconcilationdatas")
  public XfR save(@RequestBody ReconcilationData reconcilationData) {
     return XfR.ok(reconcilationDataServiceImpl.save(reconcilationData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reconcilationData ${table.comment}
   * @return XfR
   */
  @PutMapping("/reconcilationdatas/{id}")
  public XfR putUpdate(@RequestBody ReconcilationData reconcilationData,@PathVariable Long id) {
      reconcilationData.setId(id);
      return XfR.ok(reconcilationDataServiceImpl.updateById(reconcilationData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reconcilationData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reconcilationdatas/{id}")
  public XfR patchUpdate(@RequestBody ReconcilationData reconcilationData,@PathVariable Long id) {
      ReconcilationData upreconcilationData = reconcilationDataServiceImpl.getById(id);
      if(upreconcilationData != null){
        upreconcilationData = ObjectCopyUtils.copyProperties(reconcilationData,upreconcilationData,true);
      }
      return XfR.ok(reconcilationDataServiceImpl.updateById(upreconcilationData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reconcilationdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reconcilationDataServiceImpl.removeById(id));
  }

  @PostMapping("/reconcilationdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reconcilation_data");
     params.put("request", condition);

     return XfR.ok(reconcilationDataServiceImpl.querys(params));
  }

}
