package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.IncomeMainMsg;
import com.xforceplus.financialsettlement.service.IIncomeMainMsgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class IncomeMainMsgController {

  @Autowired
  private IIncomeMainMsgService incomeMainMsgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param incomeMainMsg ${table.comment}
   * @return
   */
  @GetMapping("/incomemainmsgs" )
  public XfR getIncomeMainMsgs(XfPage page, IncomeMainMsg incomeMainMsg) {
    return XfR.ok(incomeMainMsgServiceImpl.page(page, Wrappers.query(incomeMainMsg)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomemainmsgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeMainMsgServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param incomeMainMsg ${table.comment}
   * @return XfR
   */
  @PostMapping("/incomemainmsgs")
  public XfR save(@RequestBody IncomeMainMsg incomeMainMsg) {
     return XfR.ok(incomeMainMsgServiceImpl.save(incomeMainMsg));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param incomeMainMsg ${table.comment}
   * @return XfR
   */
  @PutMapping("/incomemainmsgs/{id}")
  public XfR putUpdate(@RequestBody IncomeMainMsg incomeMainMsg,@PathVariable Long id) {
      incomeMainMsg.setId(id);
      return XfR.ok(incomeMainMsgServiceImpl.updateById(incomeMainMsg));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param incomeMainMsg ${table.comment}
   * @return XfR
   */
  @PatchMapping("/incomemainmsgs/{id}")
  public XfR patchUpdate(@RequestBody IncomeMainMsg incomeMainMsg,@PathVariable Long id) {
      IncomeMainMsg upincomeMainMsg = incomeMainMsgServiceImpl.getById(id);
      if(upincomeMainMsg != null){
        upincomeMainMsg = ObjectCopyUtils.copyProperties(incomeMainMsg,upincomeMainMsg,true);
      }
      return XfR.ok(incomeMainMsgServiceImpl.updateById(upincomeMainMsg));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomemainmsgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeMainMsgServiceImpl.removeById(id));
  }

  @PostMapping("/incomemainmsgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income_main_msg");
     params.put("request", condition);

     return XfR.ok(incomeMainMsgServiceImpl.querys(params));
  }

}
