package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.PayWater;
import com.xforceplus.financialsettlement.service.IPayWaterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 支付流水前端控制器
 *
 * @author ultraman
 * @date 2022-01-24
 */
@RestController
public class PayWaterController {

  @Autowired
  private IPayWaterService payWaterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payWater 支付流水
   * @return
   */
  @GetMapping("/paywaters" )
  public XfR getPayWaters(XfPage page, PayWater payWater) {
    return XfR.ok(payWaterServiceImpl.page(page, Wrappers.query(payWater)));
  }

  /**
   * 通过id查询支付流水
   * @param  id
   * @return XfR
   */
  @GetMapping("/paywaters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payWaterServiceImpl.getById(id));
  }

  /**
   * 新增支付流水
   * @param payWater 支付流水
   * @return XfR
   */
  @PostMapping("/paywaters")
  public XfR save(@RequestBody PayWater payWater) {
     return XfR.ok(payWaterServiceImpl.save(payWater));
  }

  /**
   * 修改-传入修改后的全部数据支付流水
   * @param payWater 支付流水
   * @return XfR
   */
  @PutMapping("/paywaters/{id}")
  public XfR putUpdate(@RequestBody PayWater payWater,@PathVariable Long id) {
      payWater.setId(id);
      return XfR.ok(payWaterServiceImpl.updateById(payWater));
  }

  /**
   * 修改-传入修改的数据支付流水
   * @param payWater 支付流水
   * @return XfR
   */
  @PatchMapping("/paywaters/{id}")
  public XfR patchUpdate(@RequestBody PayWater payWater,@PathVariable Long id) {
      PayWater uppayWater = payWaterServiceImpl.getById(id);
      if(uppayWater != null){
        uppayWater = ObjectCopyUtils.copyProperties(payWater,uppayWater,true);
      }
      return XfR.ok(payWaterServiceImpl.updateById(uppayWater));
  }

  /**
   * 通过id删除支付流水
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paywaters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payWaterServiceImpl.removeById(id));
  }

  @PostMapping("/paywaters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_water");
     params.put("request", condition);

     return XfR.ok(payWaterServiceImpl.querys(params));
  }

}
