package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.IncomeSummary;
import com.xforceplus.financialsettlement.service.IIncomeSummaryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-18
 */
@RestController
public class IncomeSummaryController {

  @Autowired
  private IIncomeSummaryService incomeSummaryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param incomeSummary ${table.comment}
   * @return
   */
  @GetMapping("/incomesummarys" )
  public XfR getIncomeSummarys(XfPage page, IncomeSummary incomeSummary) {
    return XfR.ok(incomeSummaryServiceImpl.page(page, Wrappers.query(incomeSummary)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomesummarys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeSummaryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param incomeSummary ${table.comment}
   * @return XfR
   */
  @PostMapping("/incomesummarys")
  public XfR save(@RequestBody IncomeSummary incomeSummary) {
     return XfR.ok(incomeSummaryServiceImpl.save(incomeSummary));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param incomeSummary ${table.comment}
   * @return XfR
   */
  @PutMapping("/incomesummarys/{id}")
  public XfR putUpdate(@RequestBody IncomeSummary incomeSummary,@PathVariable Long id) {
      incomeSummary.setId(id);
      return XfR.ok(incomeSummaryServiceImpl.updateById(incomeSummary));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param incomeSummary ${table.comment}
   * @return XfR
   */
  @PatchMapping("/incomesummarys/{id}")
  public XfR patchUpdate(@RequestBody IncomeSummary incomeSummary,@PathVariable Long id) {
      IncomeSummary upincomeSummary = incomeSummaryServiceImpl.getById(id);
      if(upincomeSummary != null){
        upincomeSummary = ObjectCopyUtils.copyProperties(incomeSummary,upincomeSummary,true);
      }
      return XfR.ok(incomeSummaryServiceImpl.updateById(upincomeSummary));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomesummarys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeSummaryServiceImpl.removeById(id));
  }

  @PostMapping("/incomesummarys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income_summary");
     params.put("request", condition);

     return XfR.ok(incomeSummaryServiceImpl.querys(params));
  }

}
