package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.MultiDimesionRelation;
import com.xforceplus.financialsettlement.service.IMultiDimesionRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-02-21
 */
@RestController
public class MultiDimesionRelationController {

  @Autowired
  private IMultiDimesionRelationService multiDimesionRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param multiDimesionRelation ${table.comment}
   * @return
   */
  @GetMapping("/multidimesionrelations" )
  public XfR getMultiDimesionRelations(XfPage page, MultiDimesionRelation multiDimesionRelation) {
    return XfR.ok(multiDimesionRelationServiceImpl.page(page, Wrappers.query(multiDimesionRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/multidimesionrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(multiDimesionRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param multiDimesionRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/multidimesionrelations")
  public XfR save(@RequestBody MultiDimesionRelation multiDimesionRelation) {
     return XfR.ok(multiDimesionRelationServiceImpl.save(multiDimesionRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param multiDimesionRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/multidimesionrelations/{id}")
  public XfR putUpdate(@RequestBody MultiDimesionRelation multiDimesionRelation,@PathVariable Long id) {
      multiDimesionRelation.setId(id);
      return XfR.ok(multiDimesionRelationServiceImpl.updateById(multiDimesionRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param multiDimesionRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/multidimesionrelations/{id}")
  public XfR patchUpdate(@RequestBody MultiDimesionRelation multiDimesionRelation,@PathVariable Long id) {
      MultiDimesionRelation upmultiDimesionRelation = multiDimesionRelationServiceImpl.getById(id);
      if(upmultiDimesionRelation != null){
        upmultiDimesionRelation = ObjectCopyUtils.copyProperties(multiDimesionRelation,upmultiDimesionRelation,true);
      }
      return XfR.ok(multiDimesionRelationServiceImpl.updateById(upmultiDimesionRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/multidimesionrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(multiDimesionRelationServiceImpl.removeById(id));
  }

  @PostMapping("/multidimesionrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "multi_dimesion_relation");
     params.put("request", condition);

     return XfR.ok(multiDimesionRelationServiceImpl.querys(params));
  }

}
