package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.AllocationRuleDetails;
import com.xforceplus.financialsettlement.service.IAllocationRuleDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-30
 */
@RestController
public class AllocationRuleDetailsController {

  @Autowired
  private IAllocationRuleDetailsService allocationRuleDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allocationRuleDetails ${table.comment}
   * @return
   */
  @GetMapping("/allocationruledetailss" )
  public XfR getAllocationRuleDetailss(XfPage page, AllocationRuleDetails allocationRuleDetails) {
    return XfR.ok(allocationRuleDetailsServiceImpl.page(page, Wrappers.query(allocationRuleDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/allocationruledetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allocationRuleDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param allocationRuleDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/allocationruledetailss")
  public XfR save(@RequestBody AllocationRuleDetails allocationRuleDetails) {
     return XfR.ok(allocationRuleDetailsServiceImpl.save(allocationRuleDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param allocationRuleDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/allocationruledetailss/{id}")
  public XfR putUpdate(@RequestBody AllocationRuleDetails allocationRuleDetails,@PathVariable Long id) {
      allocationRuleDetails.setId(id);
      return XfR.ok(allocationRuleDetailsServiceImpl.updateById(allocationRuleDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param allocationRuleDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/allocationruledetailss/{id}")
  public XfR patchUpdate(@RequestBody AllocationRuleDetails allocationRuleDetails,@PathVariable Long id) {
      AllocationRuleDetails upallocationRuleDetails = allocationRuleDetailsServiceImpl.getById(id);
      if(upallocationRuleDetails != null){
        upallocationRuleDetails = ObjectCopyUtils.copyProperties(allocationRuleDetails,upallocationRuleDetails,true);
      }
      return XfR.ok(allocationRuleDetailsServiceImpl.updateById(upallocationRuleDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allocationruledetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allocationRuleDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/allocationruledetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allocation_rule_details");
     params.put("request", condition);

     return XfR.ok(allocationRuleDetailsServiceImpl.querys(params));
  }

}
