package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.IncomeDetailOrderRel;
import com.xforceplus.financialsettlement.service.IIncomeDetailOrderRelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-08
 */
@RestController
public class IncomeDetailOrderRelController {

  @Autowired
  private IIncomeDetailOrderRelService incomeDetailOrderRelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param incomeDetailOrderRel ${table.comment}
   * @return
   */
  @GetMapping("/incomedetailorderrels" )
  public XfR getIncomeDetailOrderRels(XfPage page, IncomeDetailOrderRel incomeDetailOrderRel) {
    return XfR.ok(incomeDetailOrderRelServiceImpl.page(page, Wrappers.query(incomeDetailOrderRel)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/incomedetailorderrels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(incomeDetailOrderRelServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param incomeDetailOrderRel ${table.comment}
   * @return XfR
   */
  @PostMapping("/incomedetailorderrels")
  public XfR save(@RequestBody IncomeDetailOrderRel incomeDetailOrderRel) {
     return XfR.ok(incomeDetailOrderRelServiceImpl.save(incomeDetailOrderRel));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param incomeDetailOrderRel ${table.comment}
   * @return XfR
   */
  @PutMapping("/incomedetailorderrels/{id}")
  public XfR putUpdate(@RequestBody IncomeDetailOrderRel incomeDetailOrderRel,@PathVariable Long id) {
      incomeDetailOrderRel.setId(id);
      return XfR.ok(incomeDetailOrderRelServiceImpl.updateById(incomeDetailOrderRel));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param incomeDetailOrderRel ${table.comment}
   * @return XfR
   */
  @PatchMapping("/incomedetailorderrels/{id}")
  public XfR patchUpdate(@RequestBody IncomeDetailOrderRel incomeDetailOrderRel,@PathVariable Long id) {
      IncomeDetailOrderRel upincomeDetailOrderRel = incomeDetailOrderRelServiceImpl.getById(id);
      if(upincomeDetailOrderRel != null){
        upincomeDetailOrderRel = ObjectCopyUtils.copyProperties(incomeDetailOrderRel,upincomeDetailOrderRel,true);
      }
      return XfR.ok(incomeDetailOrderRelServiceImpl.updateById(upincomeDetailOrderRel));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/incomedetailorderrels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(incomeDetailOrderRelServiceImpl.removeById(id));
  }

  @PostMapping("/incomedetailorderrels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "income_detail_order_rel");
     params.put("request", condition);

     return XfR.ok(incomeDetailOrderRelServiceImpl.querys(params));
  }

}
