package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Organize;
import com.xforceplus.financialsettlement.service.IOrganizeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-04-08
 */
@RestController
public class OrganizeController {

  @Autowired
  private IOrganizeService organizeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param organize ${table.comment}
   * @return
   */
  @GetMapping("/organizes" )
  public XfR getOrganizes(XfPage page, Organize organize) {
    return XfR.ok(organizeServiceImpl.page(page, Wrappers.query(organize)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/organizes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(organizeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param organize ${table.comment}
   * @return XfR
   */
  @PostMapping("/organizes")
  public XfR save(@RequestBody Organize organize) {
     return XfR.ok(organizeServiceImpl.save(organize));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param organize ${table.comment}
   * @return XfR
   */
  @PutMapping("/organizes/{id}")
  public XfR putUpdate(@RequestBody Organize organize,@PathVariable Long id) {
      organize.setId(id);
      return XfR.ok(organizeServiceImpl.updateById(organize));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param organize ${table.comment}
   * @return XfR
   */
  @PatchMapping("/organizes/{id}")
  public XfR patchUpdate(@RequestBody Organize organize,@PathVariable Long id) {
      Organize uporganize = organizeServiceImpl.getById(id);
      if(uporganize != null){
        uporganize = ObjectCopyUtils.copyProperties(organize,uporganize,true);
      }
      return XfR.ok(organizeServiceImpl.updateById(uporganize));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/organizes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(organizeServiceImpl.removeById(id));
  }

  @PostMapping("/organizes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "organize");
     params.put("request", condition);

     return XfR.ok(organizeServiceImpl.querys(params));
  }

}
