package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.StandingBookOperationRecord;
import com.xforceplus.financialsettlement.service.IStandingBookOperationRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-07
 */
@RestController
public class StandingBookOperationRecordController {

  @Autowired
  private IStandingBookOperationRecordService standingBookOperationRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standingBookOperationRecord ${table.comment}
   * @return
   */
  @GetMapping("/standingbookoperationrecords" )
  public XfR getStandingBookOperationRecords(XfPage page, StandingBookOperationRecord standingBookOperationRecord) {
    return XfR.ok(standingBookOperationRecordServiceImpl.page(page, Wrappers.query(standingBookOperationRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standingbookoperationrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standingBookOperationRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standingBookOperationRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/standingbookoperationrecords")
  public XfR save(@RequestBody StandingBookOperationRecord standingBookOperationRecord) {
     return XfR.ok(standingBookOperationRecordServiceImpl.save(standingBookOperationRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standingBookOperationRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/standingbookoperationrecords/{id}")
  public XfR putUpdate(@RequestBody StandingBookOperationRecord standingBookOperationRecord,@PathVariable Long id) {
      standingBookOperationRecord.setId(id);
      return XfR.ok(standingBookOperationRecordServiceImpl.updateById(standingBookOperationRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standingBookOperationRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standingbookoperationrecords/{id}")
  public XfR patchUpdate(@RequestBody StandingBookOperationRecord standingBookOperationRecord,@PathVariable Long id) {
      StandingBookOperationRecord upstandingBookOperationRecord = standingBookOperationRecordServiceImpl.getById(id);
      if(upstandingBookOperationRecord != null){
        upstandingBookOperationRecord = ObjectCopyUtils.copyProperties(standingBookOperationRecord,upstandingBookOperationRecord,true);
      }
      return XfR.ok(standingBookOperationRecordServiceImpl.updateById(upstandingBookOperationRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standingbookoperationrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standingBookOperationRecordServiceImpl.removeById(id));
  }

  @PostMapping("/standingbookoperationrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standing_book_operation_record");
     params.put("request", condition);

     return XfR.ok(standingBookOperationRecordServiceImpl.querys(params));
  }

}
