package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.YkbChargeCode;
import com.xforceplus.financialsettlement.service.IYkbChargeCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-05-07
 */
@RestController
public class YkbChargeCodeController {

  @Autowired
  private IYkbChargeCodeService ykbChargeCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ykbChargeCode ${table.comment}
   * @return
   */
  @GetMapping("/ykbchargecodes" )
  public XfR getYkbChargeCodes(XfPage page, YkbChargeCode ykbChargeCode) {
    return XfR.ok(ykbChargeCodeServiceImpl.page(page, Wrappers.query(ykbChargeCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ykbchargecodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ykbChargeCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ykbChargeCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/ykbchargecodes")
  public XfR save(@RequestBody YkbChargeCode ykbChargeCode) {
     return XfR.ok(ykbChargeCodeServiceImpl.save(ykbChargeCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ykbChargeCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/ykbchargecodes/{id}")
  public XfR putUpdate(@RequestBody YkbChargeCode ykbChargeCode,@PathVariable Long id) {
      ykbChargeCode.setId(id);
      return XfR.ok(ykbChargeCodeServiceImpl.updateById(ykbChargeCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ykbChargeCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ykbchargecodes/{id}")
  public XfR patchUpdate(@RequestBody YkbChargeCode ykbChargeCode,@PathVariable Long id) {
      YkbChargeCode upykbChargeCode = ykbChargeCodeServiceImpl.getById(id);
      if(upykbChargeCode != null){
        upykbChargeCode = ObjectCopyUtils.copyProperties(ykbChargeCode,upykbChargeCode,true);
      }
      return XfR.ok(ykbChargeCodeServiceImpl.updateById(upykbChargeCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ykbchargecodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ykbChargeCodeServiceImpl.removeById(id));
  }

  @PostMapping("/ykbchargecodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ykb_charge_code");
     params.put("request", condition);

     return XfR.ok(ykbChargeCodeServiceImpl.querys(params));
  }

}
