package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeData;
import com.xforceplus.financialsettlement.service.IChargeCodeDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-02
 */
@RestController
public class ChargeCodeDataController {

  @Autowired
  private IChargeCodeDataService chargeCodeDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeCodeData ${table.comment}
   * @return
   */
  @GetMapping("/chargecodedatas" )
  public XfR getChargeCodeDatas(XfPage page, ChargeCodeData chargeCodeData) {
    return XfR.ok(chargeCodeDataServiceImpl.page(page, Wrappers.query(chargeCodeData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargecodedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeCodeDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param chargeCodeData ${table.comment}
   * @return XfR
   */
  @PostMapping("/chargecodedatas")
  public XfR save(@RequestBody ChargeCodeData chargeCodeData) {
     return XfR.ok(chargeCodeDataServiceImpl.save(chargeCodeData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param chargeCodeData ${table.comment}
   * @return XfR
   */
  @PutMapping("/chargecodedatas/{id}")
  public XfR putUpdate(@RequestBody ChargeCodeData chargeCodeData,@PathVariable Long id) {
      chargeCodeData.setId(id);
      return XfR.ok(chargeCodeDataServiceImpl.updateById(chargeCodeData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param chargeCodeData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/chargecodedatas/{id}")
  public XfR patchUpdate(@RequestBody ChargeCodeData chargeCodeData,@PathVariable Long id) {
      ChargeCodeData upchargeCodeData = chargeCodeDataServiceImpl.getById(id);
      if(upchargeCodeData != null){
        upchargeCodeData = ObjectCopyUtils.copyProperties(chargeCodeData,upchargeCodeData,true);
      }
      return XfR.ok(chargeCodeDataServiceImpl.updateById(upchargeCodeData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargecodedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeCodeDataServiceImpl.removeById(id));
  }

  @PostMapping("/chargecodedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_code_data");
     params.put("request", condition);

     return XfR.ok(chargeCodeDataServiceImpl.querys(params));
  }

}
