package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.CityBillDetail;
import com.xforceplus.financialsettlement.service.ICityBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 市内交通报销单明细前端控制器
 *
 * @author ultraman
 * @date 2022-05-29
 */
@RestController
public class CityBillDetailController {

  @Autowired
  private ICityBillDetailService cityBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cityBillDetail 市内交通报销单明细
   * @return
   */
  @GetMapping("/citybilldetails" )
  public XfR getCityBillDetails(XfPage page, CityBillDetail cityBillDetail) {
    return XfR.ok(cityBillDetailServiceImpl.page(page, Wrappers.query(cityBillDetail)));
  }

  /**
   * 通过id查询市内交通报销单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/citybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cityBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增市内交通报销单明细
   * @param cityBillDetail 市内交通报销单明细
   * @return XfR
   */
  @PostMapping("/citybilldetails")
  public XfR save(@RequestBody CityBillDetail cityBillDetail) {
     return XfR.ok(cityBillDetailServiceImpl.save(cityBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据市内交通报销单明细
   * @param cityBillDetail 市内交通报销单明细
   * @return XfR
   */
  @PutMapping("/citybilldetails/{id}")
  public XfR putUpdate(@RequestBody CityBillDetail cityBillDetail,@PathVariable Long id) {
      cityBillDetail.setId(id);
      return XfR.ok(cityBillDetailServiceImpl.updateById(cityBillDetail));
  }

  /**
   * 修改-传入修改的数据市内交通报销单明细
   * @param cityBillDetail 市内交通报销单明细
   * @return XfR
   */
  @PatchMapping("/citybilldetails/{id}")
  public XfR patchUpdate(@RequestBody CityBillDetail cityBillDetail,@PathVariable Long id) {
      CityBillDetail upcityBillDetail = cityBillDetailServiceImpl.getById(id);
      if(upcityBillDetail != null){
        upcityBillDetail = ObjectCopyUtils.copyProperties(cityBillDetail,upcityBillDetail,true);
      }
      return XfR.ok(cityBillDetailServiceImpl.updateById(upcityBillDetail));
  }

  /**
   * 通过id删除市内交通报销单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/citybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cityBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/citybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "city_bill_detail");
     params.put("request", condition);

     return XfR.ok(cityBillDetailServiceImpl.querys(params));
  }

}
