package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelApplyBillDetail;
import com.xforceplus.financialsettlement.service.ITravelApplyBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 差旅申请单明细前端控制器
 *
 * @author ultraman
 * @date 2022-05-29
 */
@RestController
public class TravelApplyBillDetailController {

  @Autowired
  private ITravelApplyBillDetailService travelApplyBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelApplyBillDetail 差旅申请单明细
   * @return
   */
  @GetMapping("/travelapplybilldetails" )
  public XfR getTravelApplyBillDetails(XfPage page, TravelApplyBillDetail travelApplyBillDetail) {
    return XfR.ok(travelApplyBillDetailServiceImpl.page(page, Wrappers.query(travelApplyBillDetail)));
  }

  /**
   * 通过id查询差旅申请单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelapplybilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelApplyBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增差旅申请单明细
   * @param travelApplyBillDetail 差旅申请单明细
   * @return XfR
   */
  @PostMapping("/travelapplybilldetails")
  public XfR save(@RequestBody TravelApplyBillDetail travelApplyBillDetail) {
     return XfR.ok(travelApplyBillDetailServiceImpl.save(travelApplyBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据差旅申请单明细
   * @param travelApplyBillDetail 差旅申请单明细
   * @return XfR
   */
  @PutMapping("/travelapplybilldetails/{id}")
  public XfR putUpdate(@RequestBody TravelApplyBillDetail travelApplyBillDetail,@PathVariable Long id) {
      travelApplyBillDetail.setId(id);
      return XfR.ok(travelApplyBillDetailServiceImpl.updateById(travelApplyBillDetail));
  }

  /**
   * 修改-传入修改的数据差旅申请单明细
   * @param travelApplyBillDetail 差旅申请单明细
   * @return XfR
   */
  @PatchMapping("/travelapplybilldetails/{id}")
  public XfR patchUpdate(@RequestBody TravelApplyBillDetail travelApplyBillDetail,@PathVariable Long id) {
      TravelApplyBillDetail uptravelApplyBillDetail = travelApplyBillDetailServiceImpl.getById(id);
      if(uptravelApplyBillDetail != null){
        uptravelApplyBillDetail = ObjectCopyUtils.copyProperties(travelApplyBillDetail,uptravelApplyBillDetail,true);
      }
      return XfR.ok(travelApplyBillDetailServiceImpl.updateById(uptravelApplyBillDetail));
  }

  /**
   * 通过id删除差旅申请单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelapplybilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelApplyBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/travelapplybilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_apply_bill_detail");
     params.put("request", condition);

     return XfR.ok(travelApplyBillDetailServiceImpl.querys(params));
  }

}
