package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelBillDetail;
import com.xforceplus.financialsettlement.service.ITravelBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 差旅报销单明细前端控制器
 *
 * @author ultraman
 * @date 2022-05-29
 */
@RestController
public class TravelBillDetailController {

  @Autowired
  private ITravelBillDetailService travelBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelBillDetail 差旅报销单明细
   * @return
   */
  @GetMapping("/travelbilldetails" )
  public XfR getTravelBillDetails(XfPage page, TravelBillDetail travelBillDetail) {
    return XfR.ok(travelBillDetailServiceImpl.page(page, Wrappers.query(travelBillDetail)));
  }

  /**
   * 通过id查询差旅报销单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增差旅报销单明细
   * @param travelBillDetail 差旅报销单明细
   * @return XfR
   */
  @PostMapping("/travelbilldetails")
  public XfR save(@RequestBody TravelBillDetail travelBillDetail) {
     return XfR.ok(travelBillDetailServiceImpl.save(travelBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据差旅报销单明细
   * @param travelBillDetail 差旅报销单明细
   * @return XfR
   */
  @PutMapping("/travelbilldetails/{id}")
  public XfR putUpdate(@RequestBody TravelBillDetail travelBillDetail,@PathVariable Long id) {
      travelBillDetail.setId(id);
      return XfR.ok(travelBillDetailServiceImpl.updateById(travelBillDetail));
  }

  /**
   * 修改-传入修改的数据差旅报销单明细
   * @param travelBillDetail 差旅报销单明细
   * @return XfR
   */
  @PatchMapping("/travelbilldetails/{id}")
  public XfR patchUpdate(@RequestBody TravelBillDetail travelBillDetail,@PathVariable Long id) {
      TravelBillDetail uptravelBillDetail = travelBillDetailServiceImpl.getById(id);
      if(uptravelBillDetail != null){
        uptravelBillDetail = ObjectCopyUtils.copyProperties(travelBillDetail,uptravelBillDetail,true);
      }
      return XfR.ok(travelBillDetailServiceImpl.updateById(uptravelBillDetail));
  }

  /**
   * 通过id删除差旅报销单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/travelbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_bill_detail");
     params.put("request", condition);

     return XfR.ok(travelBillDetailServiceImpl.querys(params));
  }

}
