package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TravelReimbursementBill;
import com.xforceplus.financialsettlement.service.ITravelReimbursementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 差旅报销单前端控制器
 *
 * @author ultraman
 * @date 2022-05-29
 */
@RestController
public class TravelReimbursementBillController {

  @Autowired
  private ITravelReimbursementBillService travelReimbursementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param travelReimbursementBill 差旅报销单
   * @return
   */
  @GetMapping("/travelreimbursementbills" )
  public XfR getTravelReimbursementBills(XfPage page, TravelReimbursementBill travelReimbursementBill) {
    return XfR.ok(travelReimbursementBillServiceImpl.page(page, Wrappers.query(travelReimbursementBill)));
  }

  /**
   * 通过id查询差旅报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/travelreimbursementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(travelReimbursementBillServiceImpl.getById(id));
  }

  /**
   * 新增差旅报销单
   * @param travelReimbursementBill 差旅报销单
   * @return XfR
   */
  @PostMapping("/travelreimbursementbills")
  public XfR save(@RequestBody TravelReimbursementBill travelReimbursementBill) {
     return XfR.ok(travelReimbursementBillServiceImpl.save(travelReimbursementBill));
  }

  /**
   * 修改-传入修改后的全部数据差旅报销单
   * @param travelReimbursementBill 差旅报销单
   * @return XfR
   */
  @PutMapping("/travelreimbursementbills/{id}")
  public XfR putUpdate(@RequestBody TravelReimbursementBill travelReimbursementBill,@PathVariable Long id) {
      travelReimbursementBill.setId(id);
      return XfR.ok(travelReimbursementBillServiceImpl.updateById(travelReimbursementBill));
  }

  /**
   * 修改-传入修改的数据差旅报销单
   * @param travelReimbursementBill 差旅报销单
   * @return XfR
   */
  @PatchMapping("/travelreimbursementbills/{id}")
  public XfR patchUpdate(@RequestBody TravelReimbursementBill travelReimbursementBill,@PathVariable Long id) {
      TravelReimbursementBill uptravelReimbursementBill = travelReimbursementBillServiceImpl.getById(id);
      if(uptravelReimbursementBill != null){
        uptravelReimbursementBill = ObjectCopyUtils.copyProperties(travelReimbursementBill,uptravelReimbursementBill,true);
      }
      return XfR.ok(travelReimbursementBillServiceImpl.updateById(uptravelReimbursementBill));
  }

  /**
   * 通过id删除差旅报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/travelreimbursementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(travelReimbursementBillServiceImpl.removeById(id));
  }

  @PostMapping("/travelreimbursementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "travel_reimbursement_bill");
     params.put("request", condition);

     return XfR.ok(travelReimbursementBillServiceImpl.querys(params));
  }

}
