package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.WriteoffBasicBill;
import com.xforceplus.financialsettlement.service.IWriteoffBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 核销基础单据前端控制器
 *
 * @author ultraman
 * @date 2022-05-29
 */
@RestController
public class WriteoffBasicBillController {

  @Autowired
  private IWriteoffBasicBillService writeoffBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeoffBasicBill 核销基础单据
   * @return
   */
  @GetMapping("/writeoffbasicbills" )
  public XfR getWriteoffBasicBills(XfPage page, WriteoffBasicBill writeoffBasicBill) {
    return XfR.ok(writeoffBasicBillServiceImpl.page(page, Wrappers.query(writeoffBasicBill)));
  }

  /**
   * 通过id查询核销基础单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeoffBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增核销基础单据
   * @param writeoffBasicBill 核销基础单据
   * @return XfR
   */
  @PostMapping("/writeoffbasicbills")
  public XfR save(@RequestBody WriteoffBasicBill writeoffBasicBill) {
     return XfR.ok(writeoffBasicBillServiceImpl.save(writeoffBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据核销基础单据
   * @param writeoffBasicBill 核销基础单据
   * @return XfR
   */
  @PutMapping("/writeoffbasicbills/{id}")
  public XfR putUpdate(@RequestBody WriteoffBasicBill writeoffBasicBill,@PathVariable Long id) {
      writeoffBasicBill.setId(id);
      return XfR.ok(writeoffBasicBillServiceImpl.updateById(writeoffBasicBill));
  }

  /**
   * 修改-传入修改的数据核销基础单据
   * @param writeoffBasicBill 核销基础单据
   * @return XfR
   */
  @PatchMapping("/writeoffbasicbills/{id}")
  public XfR patchUpdate(@RequestBody WriteoffBasicBill writeoffBasicBill,@PathVariable Long id) {
      WriteoffBasicBill upwriteoffBasicBill = writeoffBasicBillServiceImpl.getById(id);
      if(upwriteoffBasicBill != null){
        upwriteoffBasicBill = ObjectCopyUtils.copyProperties(writeoffBasicBill,upwriteoffBasicBill,true);
      }
      return XfR.ok(writeoffBasicBillServiceImpl.updateById(upwriteoffBasicBill));
  }

  /**
   * 通过id删除核销基础单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeoffBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "writeoff_basic_bill");
     params.put("request", condition);

     return XfR.ok(writeoffBasicBillServiceImpl.querys(params));
  }

}
