package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.InvoiceRawData;
import com.xforceplus.financialsettlement.service.IInvoiceRawDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票裸数据前端控制器
 *
 * @author ultraman
 * @date 2022-06-14
 */
@RestController
public class InvoiceRawDataController {

  @Autowired
  private IInvoiceRawDataService invoiceRawDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRawData 发票裸数据
   * @return
   */
  @GetMapping("/invoicerawdatas" )
  public XfR getInvoiceRawDatas(XfPage page, InvoiceRawData invoiceRawData) {
    return XfR.ok(invoiceRawDataServiceImpl.page(page, Wrappers.query(invoiceRawData)));
  }

  /**
   * 通过id查询发票裸数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicerawdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRawDataServiceImpl.getById(id));
  }

  /**
   * 新增发票裸数据
   * @param invoiceRawData 发票裸数据
   * @return XfR
   */
  @PostMapping("/invoicerawdatas")
  public XfR save(@RequestBody InvoiceRawData invoiceRawData) {
     return XfR.ok(invoiceRawDataServiceImpl.save(invoiceRawData));
  }

  /**
   * 修改-传入修改后的全部数据发票裸数据
   * @param invoiceRawData 发票裸数据
   * @return XfR
   */
  @PutMapping("/invoicerawdatas/{id}")
  public XfR putUpdate(@RequestBody InvoiceRawData invoiceRawData,@PathVariable Long id) {
      invoiceRawData.setId(id);
      return XfR.ok(invoiceRawDataServiceImpl.updateById(invoiceRawData));
  }

  /**
   * 修改-传入修改的数据发票裸数据
   * @param invoiceRawData 发票裸数据
   * @return XfR
   */
  @PatchMapping("/invoicerawdatas/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRawData invoiceRawData,@PathVariable Long id) {
      InvoiceRawData upinvoiceRawData = invoiceRawDataServiceImpl.getById(id);
      if(upinvoiceRawData != null){
        upinvoiceRawData = ObjectCopyUtils.copyProperties(invoiceRawData,upinvoiceRawData,true);
      }
      return XfR.ok(invoiceRawDataServiceImpl.updateById(upinvoiceRawData));
  }

  /**
   * 通过id删除发票裸数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicerawdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRawDataServiceImpl.removeById(id));
  }

  @PostMapping("/invoicerawdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_raw_data");
     params.put("request", condition);

     return XfR.ok(invoiceRawDataServiceImpl.querys(params));
  }

}
