package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialAssetCheckBill;
import com.xforceplus.financialsettlement.service.IFinancialAssetCheckBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-15
 */
@RestController
public class FinancialAssetCheckBillController {

  @Autowired
  private IFinancialAssetCheckBillService financialAssetCheckBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialAssetCheckBill ${table.comment}
   * @return
   */
  @GetMapping("/financialassetcheckbills" )
  public XfR getFinancialAssetCheckBills(XfPage page, FinancialAssetCheckBill financialAssetCheckBill) {
    return XfR.ok(financialAssetCheckBillServiceImpl.page(page, Wrappers.query(financialAssetCheckBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialassetcheckbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialAssetCheckBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialAssetCheckBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialassetcheckbills")
  public XfR save(@RequestBody FinancialAssetCheckBill financialAssetCheckBill) {
     return XfR.ok(financialAssetCheckBillServiceImpl.save(financialAssetCheckBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialAssetCheckBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialassetcheckbills/{id}")
  public XfR putUpdate(@RequestBody FinancialAssetCheckBill financialAssetCheckBill,@PathVariable Long id) {
      financialAssetCheckBill.setId(id);
      return XfR.ok(financialAssetCheckBillServiceImpl.updateById(financialAssetCheckBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialAssetCheckBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialassetcheckbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialAssetCheckBill financialAssetCheckBill,@PathVariable Long id) {
      FinancialAssetCheckBill upfinancialAssetCheckBill = financialAssetCheckBillServiceImpl.getById(id);
      if(upfinancialAssetCheckBill != null){
        upfinancialAssetCheckBill = ObjectCopyUtils.copyProperties(financialAssetCheckBill,upfinancialAssetCheckBill,true);
      }
      return XfR.ok(financialAssetCheckBillServiceImpl.updateById(upfinancialAssetCheckBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialassetcheckbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialAssetCheckBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialassetcheckbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_asset_check_bill");
     params.put("request", condition);

     return XfR.ok(financialAssetCheckBillServiceImpl.querys(params));
  }

}
