package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialReimbursementBasicBill;
import com.xforceplus.financialsettlement.service.IFinancialReimbursementBasicBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-15
 */
@RestController
public class FinancialReimbursementBasicBillController {

  @Autowired
  private IFinancialReimbursementBasicBillService financialReimbursementBasicBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialReimbursementBasicBill ${table.comment}
   * @return
   */
  @GetMapping("/financialreimbursementbasicbills" )
  public XfR getFinancialReimbursementBasicBills(XfPage page, FinancialReimbursementBasicBill financialReimbursementBasicBill) {
    return XfR.ok(financialReimbursementBasicBillServiceImpl.page(page, Wrappers.query(financialReimbursementBasicBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialreimbursementbasicbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialReimbursementBasicBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialReimbursementBasicBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialreimbursementbasicbills")
  public XfR save(@RequestBody FinancialReimbursementBasicBill financialReimbursementBasicBill) {
     return XfR.ok(financialReimbursementBasicBillServiceImpl.save(financialReimbursementBasicBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialReimbursementBasicBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialreimbursementbasicbills/{id}")
  public XfR putUpdate(@RequestBody FinancialReimbursementBasicBill financialReimbursementBasicBill,@PathVariable Long id) {
      financialReimbursementBasicBill.setId(id);
      return XfR.ok(financialReimbursementBasicBillServiceImpl.updateById(financialReimbursementBasicBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialReimbursementBasicBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialreimbursementbasicbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialReimbursementBasicBill financialReimbursementBasicBill,@PathVariable Long id) {
      FinancialReimbursementBasicBill upfinancialReimbursementBasicBill = financialReimbursementBasicBillServiceImpl.getById(id);
      if(upfinancialReimbursementBasicBill != null){
        upfinancialReimbursementBasicBill = ObjectCopyUtils.copyProperties(financialReimbursementBasicBill,upfinancialReimbursementBasicBill,true);
      }
      return XfR.ok(financialReimbursementBasicBillServiceImpl.updateById(upfinancialReimbursementBasicBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialreimbursementbasicbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialReimbursementBasicBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialreimbursementbasicbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_reimbursement_basic_bill");
     params.put("request", condition);

     return XfR.ok(financialReimbursementBasicBillServiceImpl.querys(params));
  }

}
