package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeJob;
import com.xforceplus.financialsettlement.service.IChargeJobService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 计费定时列表-(废弃)前端控制器
 *
 * @author ultraman
 * @date 2022-07-11
 */
@RestController
public class ChargeJobController {

  @Autowired
  private IChargeJobService chargeJobServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param chargeJob 计费定时列表-(废弃)
   * @return
   */
  @GetMapping("/chargejobs" )
  public XfR getChargeJobs(XfPage page, ChargeJob chargeJob) {
    return XfR.ok(chargeJobServiceImpl.page(page, Wrappers.query(chargeJob)));
  }

  /**
   * 通过id查询计费定时列表-(废弃)
   * @param  id
   * @return XfR
   */
  @GetMapping("/chargejobs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(chargeJobServiceImpl.getById(id));
  }

  /**
   * 新增计费定时列表-(废弃)
   * @param chargeJob 计费定时列表-(废弃)
   * @return XfR
   */
  @PostMapping("/chargejobs")
  public XfR save(@RequestBody ChargeJob chargeJob) {
     return XfR.ok(chargeJobServiceImpl.save(chargeJob));
  }

  /**
   * 修改-传入修改后的全部数据计费定时列表-(废弃)
   * @param chargeJob 计费定时列表-(废弃)
   * @return XfR
   */
  @PutMapping("/chargejobs/{id}")
  public XfR putUpdate(@RequestBody ChargeJob chargeJob,@PathVariable Long id) {
      chargeJob.setId(id);
      return XfR.ok(chargeJobServiceImpl.updateById(chargeJob));
  }

  /**
   * 修改-传入修改的数据计费定时列表-(废弃)
   * @param chargeJob 计费定时列表-(废弃)
   * @return XfR
   */
  @PatchMapping("/chargejobs/{id}")
  public XfR patchUpdate(@RequestBody ChargeJob chargeJob,@PathVariable Long id) {
      ChargeJob upchargeJob = chargeJobServiceImpl.getById(id);
      if(upchargeJob != null){
        upchargeJob = ObjectCopyUtils.copyProperties(chargeJob,upchargeJob,true);
      }
      return XfR.ok(chargeJobServiceImpl.updateById(upchargeJob));
  }

  /**
   * 通过id删除计费定时列表-(废弃)
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/chargejobs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(chargeJobServiceImpl.removeById(id));
  }

  @PostMapping("/chargejobs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "charge_job");
     params.put("request", condition);

     return XfR.ok(chargeJobServiceImpl.querys(params));
  }

}
