package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialDailyBill;
import com.xforceplus.financialsettlement.service.IFinancialDailyBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 日常报销单前端控制器
 *
 * @author ultraman
 * @date 2022-07-11
 */
@RestController
public class FinancialDailyBillController {

  @Autowired
  private IFinancialDailyBillService financialDailyBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialDailyBill 日常报销单
   * @return
   */
  @GetMapping("/financialdailybills" )
  public XfR getFinancialDailyBills(XfPage page, FinancialDailyBill financialDailyBill) {
    return XfR.ok(financialDailyBillServiceImpl.page(page, Wrappers.query(financialDailyBill)));
  }

  /**
   * 通过id查询日常报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialdailybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialDailyBillServiceImpl.getById(id));
  }

  /**
   * 新增日常报销单
   * @param financialDailyBill 日常报销单
   * @return XfR
   */
  @PostMapping("/financialdailybills")
  public XfR save(@RequestBody FinancialDailyBill financialDailyBill) {
     return XfR.ok(financialDailyBillServiceImpl.save(financialDailyBill));
  }

  /**
   * 修改-传入修改后的全部数据日常报销单
   * @param financialDailyBill 日常报销单
   * @return XfR
   */
  @PutMapping("/financialdailybills/{id}")
  public XfR putUpdate(@RequestBody FinancialDailyBill financialDailyBill,@PathVariable Long id) {
      financialDailyBill.setId(id);
      return XfR.ok(financialDailyBillServiceImpl.updateById(financialDailyBill));
  }

  /**
   * 修改-传入修改的数据日常报销单
   * @param financialDailyBill 日常报销单
   * @return XfR
   */
  @PatchMapping("/financialdailybills/{id}")
  public XfR patchUpdate(@RequestBody FinancialDailyBill financialDailyBill,@PathVariable Long id) {
      FinancialDailyBill upfinancialDailyBill = financialDailyBillServiceImpl.getById(id);
      if(upfinancialDailyBill != null){
        upfinancialDailyBill = ObjectCopyUtils.copyProperties(financialDailyBill,upfinancialDailyBill,true);
      }
      return XfR.ok(financialDailyBillServiceImpl.updateById(upfinancialDailyBill));
  }

  /**
   * 通过id删除日常报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialdailybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialDailyBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialdailybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_daily_bill");
     params.put("request", condition);

     return XfR.ok(financialDailyBillServiceImpl.querys(params));
  }

}
