package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.InvoiceData;
import com.xforceplus.financialsettlement.service.IInvoiceDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票数据前端控制器
 *
 * @author ultraman
 * @date 2022-07-11
 */
@RestController
public class InvoiceDataController {

  @Autowired
  private IInvoiceDataService invoiceDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceData 发票数据
   * @return
   */
  @GetMapping("/invoicedatas" )
  public XfR getInvoiceDatas(XfPage page, InvoiceData invoiceData) {
    return XfR.ok(invoiceDataServiceImpl.page(page, Wrappers.query(invoiceData)));
  }

  /**
   * 通过id查询发票数据
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceDataServiceImpl.getById(id));
  }

  /**
   * 新增发票数据
   * @param invoiceData 发票数据
   * @return XfR
   */
  @PostMapping("/invoicedatas")
  public XfR save(@RequestBody InvoiceData invoiceData) {
     return XfR.ok(invoiceDataServiceImpl.save(invoiceData));
  }

  /**
   * 修改-传入修改后的全部数据发票数据
   * @param invoiceData 发票数据
   * @return XfR
   */
  @PutMapping("/invoicedatas/{id}")
  public XfR putUpdate(@RequestBody InvoiceData invoiceData,@PathVariable Long id) {
      invoiceData.setId(id);
      return XfR.ok(invoiceDataServiceImpl.updateById(invoiceData));
  }

  /**
   * 修改-传入修改的数据发票数据
   * @param invoiceData 发票数据
   * @return XfR
   */
  @PatchMapping("/invoicedatas/{id}")
  public XfR patchUpdate(@RequestBody InvoiceData invoiceData,@PathVariable Long id) {
      InvoiceData upinvoiceData = invoiceDataServiceImpl.getById(id);
      if(upinvoiceData != null){
        upinvoiceData = ObjectCopyUtils.copyProperties(invoiceData,upinvoiceData,true);
      }
      return XfR.ok(invoiceDataServiceImpl.updateById(upinvoiceData));
  }

  /**
   * 通过id删除发票数据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceDataServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_data");
     params.put("request", condition);

     return XfR.ok(invoiceDataServiceImpl.querys(params));
  }

}
