package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.DepartmentCost;
import com.xforceplus.financialsettlement.service.IDepartmentCostService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-21
 */
@RestController
public class DepartmentCostController {

  @Autowired
  private IDepartmentCostService departmentCostServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param departmentCost ${table.comment}
   * @return
   */
  @GetMapping("/departmentcosts" )
  public XfR getDepartmentCosts(XfPage page, DepartmentCost departmentCost) {
    return XfR.ok(departmentCostServiceImpl.page(page, Wrappers.query(departmentCost)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/departmentcosts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(departmentCostServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param departmentCost ${table.comment}
   * @return XfR
   */
  @PostMapping("/departmentcosts")
  public XfR save(@RequestBody DepartmentCost departmentCost) {
     return XfR.ok(departmentCostServiceImpl.save(departmentCost));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param departmentCost ${table.comment}
   * @return XfR
   */
  @PutMapping("/departmentcosts/{id}")
  public XfR putUpdate(@RequestBody DepartmentCost departmentCost,@PathVariable Long id) {
      departmentCost.setId(id);
      return XfR.ok(departmentCostServiceImpl.updateById(departmentCost));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param departmentCost ${table.comment}
   * @return XfR
   */
  @PatchMapping("/departmentcosts/{id}")
  public XfR patchUpdate(@RequestBody DepartmentCost departmentCost,@PathVariable Long id) {
      DepartmentCost updepartmentCost = departmentCostServiceImpl.getById(id);
      if(updepartmentCost != null){
        updepartmentCost = ObjectCopyUtils.copyProperties(departmentCost,updepartmentCost,true);
      }
      return XfR.ok(departmentCostServiceImpl.updateById(updepartmentCost));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/departmentcosts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(departmentCostServiceImpl.removeById(id));
  }

  @PostMapping("/departmentcosts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "department_cost");
     params.put("request", condition);

     return XfR.ok(departmentCostServiceImpl.querys(params));
  }

}
