package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderTaxRelation;
import com.xforceplus.financialsettlement.service.IOrderTaxRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-07-21
 */
@RestController
public class OrderTaxRelationController {

  @Autowired
  private IOrderTaxRelationService orderTaxRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderTaxRelation ${table.comment}
   * @return
   */
  @GetMapping("/ordertaxrelations" )
  public XfR getOrderTaxRelations(XfPage page, OrderTaxRelation orderTaxRelation) {
    return XfR.ok(orderTaxRelationServiceImpl.page(page, Wrappers.query(orderTaxRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordertaxrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderTaxRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderTaxRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordertaxrelations")
  public XfR save(@RequestBody OrderTaxRelation orderTaxRelation) {
     return XfR.ok(orderTaxRelationServiceImpl.save(orderTaxRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderTaxRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordertaxrelations/{id}")
  public XfR putUpdate(@RequestBody OrderTaxRelation orderTaxRelation,@PathVariable Long id) {
      orderTaxRelation.setId(id);
      return XfR.ok(orderTaxRelationServiceImpl.updateById(orderTaxRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderTaxRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordertaxrelations/{id}")
  public XfR patchUpdate(@RequestBody OrderTaxRelation orderTaxRelation,@PathVariable Long id) {
      OrderTaxRelation uporderTaxRelation = orderTaxRelationServiceImpl.getById(id);
      if(uporderTaxRelation != null){
        uporderTaxRelation = ObjectCopyUtils.copyProperties(orderTaxRelation,uporderTaxRelation,true);
      }
      return XfR.ok(orderTaxRelationServiceImpl.updateById(uporderTaxRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordertaxrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderTaxRelationServiceImpl.removeById(id));
  }

  @PostMapping("/ordertaxrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_tax_relation");
     params.put("request", condition);

     return XfR.ok(orderTaxRelationServiceImpl.querys(params));
  }

}
