package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ImportBatchClaimData;
import com.xforceplus.financialsettlement.service.IImportBatchClaimDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-09
 */
@RestController
public class ImportBatchClaimDataController {

  @Autowired
  private IImportBatchClaimDataService importBatchClaimDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importBatchClaimData ${table.comment}
   * @return
   */
  @GetMapping("/importbatchclaimdatas" )
  public XfR getImportBatchClaimDatas(XfPage page, ImportBatchClaimData importBatchClaimData) {
    return XfR.ok(importBatchClaimDataServiceImpl.page(page, Wrappers.query(importBatchClaimData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importbatchclaimdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importBatchClaimDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importBatchClaimData ${table.comment}
   * @return XfR
   */
  @PostMapping("/importbatchclaimdatas")
  public XfR save(@RequestBody ImportBatchClaimData importBatchClaimData) {
     return XfR.ok(importBatchClaimDataServiceImpl.save(importBatchClaimData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importBatchClaimData ${table.comment}
   * @return XfR
   */
  @PutMapping("/importbatchclaimdatas/{id}")
  public XfR putUpdate(@RequestBody ImportBatchClaimData importBatchClaimData,@PathVariable Long id) {
      importBatchClaimData.setId(id);
      return XfR.ok(importBatchClaimDataServiceImpl.updateById(importBatchClaimData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importBatchClaimData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importbatchclaimdatas/{id}")
  public XfR patchUpdate(@RequestBody ImportBatchClaimData importBatchClaimData,@PathVariable Long id) {
      ImportBatchClaimData upimportBatchClaimData = importBatchClaimDataServiceImpl.getById(id);
      if(upimportBatchClaimData != null){
        upimportBatchClaimData = ObjectCopyUtils.copyProperties(importBatchClaimData,upimportBatchClaimData,true);
      }
      return XfR.ok(importBatchClaimDataServiceImpl.updateById(upimportBatchClaimData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importbatchclaimdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importBatchClaimDataServiceImpl.removeById(id));
  }

  @PostMapping("/importbatchclaimdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_batch_claim_data");
     params.put("request", condition);

     return XfR.ok(importBatchClaimDataServiceImpl.querys(params));
  }

}
