package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialSaleReturnBill;
import com.xforceplus.financialsettlement.service.IFinancialSaleReturnBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-08-31
 */
@RestController
public class FinancialSaleReturnBillController {

  @Autowired
  private IFinancialSaleReturnBillService financialSaleReturnBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialSaleReturnBill ${table.comment}
   * @return
   */
  @GetMapping("/financialsalereturnbills" )
  public XfR getFinancialSaleReturnBills(XfPage page, FinancialSaleReturnBill financialSaleReturnBill) {
    return XfR.ok(financialSaleReturnBillServiceImpl.page(page, Wrappers.query(financialSaleReturnBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialsalereturnbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialSaleReturnBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param financialSaleReturnBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/financialsalereturnbills")
  public XfR save(@RequestBody FinancialSaleReturnBill financialSaleReturnBill) {
     return XfR.ok(financialSaleReturnBillServiceImpl.save(financialSaleReturnBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param financialSaleReturnBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/financialsalereturnbills/{id}")
  public XfR putUpdate(@RequestBody FinancialSaleReturnBill financialSaleReturnBill,@PathVariable Long id) {
      financialSaleReturnBill.setId(id);
      return XfR.ok(financialSaleReturnBillServiceImpl.updateById(financialSaleReturnBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param financialSaleReturnBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/financialsalereturnbills/{id}")
  public XfR patchUpdate(@RequestBody FinancialSaleReturnBill financialSaleReturnBill,@PathVariable Long id) {
      FinancialSaleReturnBill upfinancialSaleReturnBill = financialSaleReturnBillServiceImpl.getById(id);
      if(upfinancialSaleReturnBill != null){
        upfinancialSaleReturnBill = ObjectCopyUtils.copyProperties(financialSaleReturnBill,upfinancialSaleReturnBill,true);
      }
      return XfR.ok(financialSaleReturnBillServiceImpl.updateById(upfinancialSaleReturnBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialsalereturnbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialSaleReturnBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialsalereturnbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_sale_return_bill");
     params.put("request", condition);

     return XfR.ok(financialSaleReturnBillServiceImpl.querys(params));
  }

}
