package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ProductFunction;
import com.xforceplus.financialsettlement.service.IProductFunctionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 产品功能前端控制器
 *
 * @author ultraman
 * @date 2022-08-31
 */
@RestController
public class ProductFunctionController {

  @Autowired
  private IProductFunctionService productFunctionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productFunction 产品功能
   * @return
   */
  @GetMapping("/productfunctions" )
  public XfR getProductFunctions(XfPage page, ProductFunction productFunction) {
    return XfR.ok(productFunctionServiceImpl.page(page, Wrappers.query(productFunction)));
  }

  /**
   * 通过id查询产品功能
   * @param  id
   * @return XfR
   */
  @GetMapping("/productfunctions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productFunctionServiceImpl.getById(id));
  }

  /**
   * 新增产品功能
   * @param productFunction 产品功能
   * @return XfR
   */
  @PostMapping("/productfunctions")
  public XfR save(@RequestBody ProductFunction productFunction) {
     return XfR.ok(productFunctionServiceImpl.save(productFunction));
  }

  /**
   * 修改-传入修改后的全部数据产品功能
   * @param productFunction 产品功能
   * @return XfR
   */
  @PutMapping("/productfunctions/{id}")
  public XfR putUpdate(@RequestBody ProductFunction productFunction,@PathVariable Long id) {
      productFunction.setId(id);
      return XfR.ok(productFunctionServiceImpl.updateById(productFunction));
  }

  /**
   * 修改-传入修改的数据产品功能
   * @param productFunction 产品功能
   * @return XfR
   */
  @PatchMapping("/productfunctions/{id}")
  public XfR patchUpdate(@RequestBody ProductFunction productFunction,@PathVariable Long id) {
      ProductFunction upproductFunction = productFunctionServiceImpl.getById(id);
      if(upproductFunction != null){
        upproductFunction = ObjectCopyUtils.copyProperties(productFunction,upproductFunction,true);
      }
      return XfR.ok(productFunctionServiceImpl.updateById(upproductFunction));
  }

  /**
   * 通过id删除产品功能
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productfunctions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productFunctionServiceImpl.removeById(id));
  }

  @PostMapping("/productfunctions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_function");
     params.put("request", condition);

     return XfR.ok(productFunctionServiceImpl.querys(params));
  }

}
