package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.AllocationByOrder;
import com.xforceplus.financialsettlement.service.IAllocationByOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 废弃前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class AllocationByOrderController {

  @Autowired
  private IAllocationByOrderService allocationByOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allocationByOrder 废弃
   * @return
   */
  @GetMapping("/allocationbyorders" )
  public XfR getAllocationByOrders(XfPage page, AllocationByOrder allocationByOrder) {
    return XfR.ok(allocationByOrderServiceImpl.page(page, Wrappers.query(allocationByOrder)));
  }

  /**
   * 通过id查询废弃
   * @param  id
   * @return XfR
   */
  @GetMapping("/allocationbyorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allocationByOrderServiceImpl.getById(id));
  }

  /**
   * 新增废弃
   * @param allocationByOrder 废弃
   * @return XfR
   */
  @PostMapping("/allocationbyorders")
  public XfR save(@RequestBody AllocationByOrder allocationByOrder) {
     return XfR.ok(allocationByOrderServiceImpl.save(allocationByOrder));
  }

  /**
   * 修改-传入修改后的全部数据废弃
   * @param allocationByOrder 废弃
   * @return XfR
   */
  @PutMapping("/allocationbyorders/{id}")
  public XfR putUpdate(@RequestBody AllocationByOrder allocationByOrder,@PathVariable Long id) {
      allocationByOrder.setId(id);
      return XfR.ok(allocationByOrderServiceImpl.updateById(allocationByOrder));
  }

  /**
   * 修改-传入修改的数据废弃
   * @param allocationByOrder 废弃
   * @return XfR
   */
  @PatchMapping("/allocationbyorders/{id}")
  public XfR patchUpdate(@RequestBody AllocationByOrder allocationByOrder,@PathVariable Long id) {
      AllocationByOrder upallocationByOrder = allocationByOrderServiceImpl.getById(id);
      if(upallocationByOrder != null){
        upallocationByOrder = ObjectCopyUtils.copyProperties(allocationByOrder,upallocationByOrder,true);
      }
      return XfR.ok(allocationByOrderServiceImpl.updateById(upallocationByOrder));
  }

  /**
   * 通过id删除废弃
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allocationbyorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allocationByOrderServiceImpl.removeById(id));
  }

  @PostMapping("/allocationbyorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allocation_by_order");
     params.put("request", condition);

     return XfR.ok(allocationByOrderServiceImpl.querys(params));
  }

}
