package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialTeamBuildingBillDetail;
import com.xforceplus.financialsettlement.service.IFinancialTeamBuildingBillDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 团建费报销单明细前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class FinancialTeamBuildingBillDetailController {

  @Autowired
  private IFinancialTeamBuildingBillDetailService financialTeamBuildingBillDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return
   */
  @GetMapping("/financialteambuildingbilldetails" )
  public XfR getFinancialTeamBuildingBillDetails(XfPage page, FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail) {
    return XfR.ok(financialTeamBuildingBillDetailServiceImpl.page(page, Wrappers.query(financialTeamBuildingBillDetail)));
  }

  /**
   * 通过id查询团建费报销单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialteambuildingbilldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialTeamBuildingBillDetailServiceImpl.getById(id));
  }

  /**
   * 新增团建费报销单明细
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return XfR
   */
  @PostMapping("/financialteambuildingbilldetails")
  public XfR save(@RequestBody FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail) {
     return XfR.ok(financialTeamBuildingBillDetailServiceImpl.save(financialTeamBuildingBillDetail));
  }

  /**
   * 修改-传入修改后的全部数据团建费报销单明细
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return XfR
   */
  @PutMapping("/financialteambuildingbilldetails/{id}")
  public XfR putUpdate(@RequestBody FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail,@PathVariable Long id) {
      financialTeamBuildingBillDetail.setId(id);
      return XfR.ok(financialTeamBuildingBillDetailServiceImpl.updateById(financialTeamBuildingBillDetail));
  }

  /**
   * 修改-传入修改的数据团建费报销单明细
   * @param financialTeamBuildingBillDetail 团建费报销单明细
   * @return XfR
   */
  @PatchMapping("/financialteambuildingbilldetails/{id}")
  public XfR patchUpdate(@RequestBody FinancialTeamBuildingBillDetail financialTeamBuildingBillDetail,@PathVariable Long id) {
      FinancialTeamBuildingBillDetail upfinancialTeamBuildingBillDetail = financialTeamBuildingBillDetailServiceImpl.getById(id);
      if(upfinancialTeamBuildingBillDetail != null){
        upfinancialTeamBuildingBillDetail = ObjectCopyUtils.copyProperties(financialTeamBuildingBillDetail,upfinancialTeamBuildingBillDetail,true);
      }
      return XfR.ok(financialTeamBuildingBillDetailServiceImpl.updateById(upfinancialTeamBuildingBillDetail));
  }

  /**
   * 通过id删除团建费报销单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialteambuildingbilldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialTeamBuildingBillDetailServiceImpl.removeById(id));
  }

  @PostMapping("/financialteambuildingbilldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_team_building_bill_detail");
     params.put("request", condition);

     return XfR.ok(financialTeamBuildingBillDetailServiceImpl.querys(params));
  }

}
