package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderReceptionInfo;
import com.xforceplus.financialsettlement.service.IOrderReceptionInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class OrderReceptionInfoController {

  @Autowired
  private IOrderReceptionInfoService orderReceptionInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderReceptionInfo ${table.comment}
   * @return
   */
  @GetMapping("/orderreceptioninfos" )
  public XfR getOrderReceptionInfos(XfPage page, OrderReceptionInfo orderReceptionInfo) {
    return XfR.ok(orderReceptionInfoServiceImpl.page(page, Wrappers.query(orderReceptionInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderreceptioninfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderReceptionInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderReceptionInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderreceptioninfos")
  public XfR save(@RequestBody OrderReceptionInfo orderReceptionInfo) {
     return XfR.ok(orderReceptionInfoServiceImpl.save(orderReceptionInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderReceptionInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderreceptioninfos/{id}")
  public XfR putUpdate(@RequestBody OrderReceptionInfo orderReceptionInfo,@PathVariable Long id) {
      orderReceptionInfo.setId(id);
      return XfR.ok(orderReceptionInfoServiceImpl.updateById(orderReceptionInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderReceptionInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderreceptioninfos/{id}")
  public XfR patchUpdate(@RequestBody OrderReceptionInfo orderReceptionInfo,@PathVariable Long id) {
      OrderReceptionInfo uporderReceptionInfo = orderReceptionInfoServiceImpl.getById(id);
      if(uporderReceptionInfo != null){
        uporderReceptionInfo = ObjectCopyUtils.copyProperties(orderReceptionInfo,uporderReceptionInfo,true);
      }
      return XfR.ok(orderReceptionInfoServiceImpl.updateById(uporderReceptionInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderreceptioninfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderReceptionInfoServiceImpl.removeById(id));
  }

  @PostMapping("/orderreceptioninfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_reception_info");
     params.put("request", condition);

     return XfR.ok(orderReceptionInfoServiceImpl.querys(params));
  }

}
