package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.RecordTable;
import com.xforceplus.financialsettlement.service.IRecordTableService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 记录表前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class RecordTableController {

  @Autowired
  private IRecordTableService recordTableServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param recordTable 记录表
   * @return
   */
  @GetMapping("/recordtables" )
  public XfR getRecordTables(XfPage page, RecordTable recordTable) {
    return XfR.ok(recordTableServiceImpl.page(page, Wrappers.query(recordTable)));
  }

  /**
   * 通过id查询记录表
   * @param  id
   * @return XfR
   */
  @GetMapping("/recordtables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(recordTableServiceImpl.getById(id));
  }

  /**
   * 新增记录表
   * @param recordTable 记录表
   * @return XfR
   */
  @PostMapping("/recordtables")
  public XfR save(@RequestBody RecordTable recordTable) {
     return XfR.ok(recordTableServiceImpl.save(recordTable));
  }

  /**
   * 修改-传入修改后的全部数据记录表
   * @param recordTable 记录表
   * @return XfR
   */
  @PutMapping("/recordtables/{id}")
  public XfR putUpdate(@RequestBody RecordTable recordTable,@PathVariable Long id) {
      recordTable.setId(id);
      return XfR.ok(recordTableServiceImpl.updateById(recordTable));
  }

  /**
   * 修改-传入修改的数据记录表
   * @param recordTable 记录表
   * @return XfR
   */
  @PatchMapping("/recordtables/{id}")
  public XfR patchUpdate(@RequestBody RecordTable recordTable,@PathVariable Long id) {
      RecordTable uprecordTable = recordTableServiceImpl.getById(id);
      if(uprecordTable != null){
        uprecordTable = ObjectCopyUtils.copyProperties(recordTable,uprecordTable,true);
      }
      return XfR.ok(recordTableServiceImpl.updateById(uprecordTable));
  }

  /**
   * 通过id删除记录表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/recordtables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(recordTableServiceImpl.removeById(id));
  }

  @PostMapping("/recordtables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "record_table");
     params.put("request", condition);

     return XfR.ok(recordTableServiceImpl.querys(params));
  }

}
