package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.TaxNoList;
import com.xforceplus.financialsettlement.service.ITaxNoListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 税号清单前端控制器
 *
 * @author ultraman
 * @date 2022-09-09
 */
@RestController
public class TaxNoListController {

  @Autowired
  private ITaxNoListService taxNoListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxNoList 税号清单
   * @return
   */
  @GetMapping("/taxnolists" )
  public XfR getTaxNoLists(XfPage page, TaxNoList taxNoList) {
    return XfR.ok(taxNoListServiceImpl.page(page, Wrappers.query(taxNoList)));
  }

  /**
   * 通过id查询税号清单
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxnolists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxNoListServiceImpl.getById(id));
  }

  /**
   * 新增税号清单
   * @param taxNoList 税号清单
   * @return XfR
   */
  @PostMapping("/taxnolists")
  public XfR save(@RequestBody TaxNoList taxNoList) {
     return XfR.ok(taxNoListServiceImpl.save(taxNoList));
  }

  /**
   * 修改-传入修改后的全部数据税号清单
   * @param taxNoList 税号清单
   * @return XfR
   */
  @PutMapping("/taxnolists/{id}")
  public XfR putUpdate(@RequestBody TaxNoList taxNoList,@PathVariable Long id) {
      taxNoList.setId(id);
      return XfR.ok(taxNoListServiceImpl.updateById(taxNoList));
  }

  /**
   * 修改-传入修改的数据税号清单
   * @param taxNoList 税号清单
   * @return XfR
   */
  @PatchMapping("/taxnolists/{id}")
  public XfR patchUpdate(@RequestBody TaxNoList taxNoList,@PathVariable Long id) {
      TaxNoList uptaxNoList = taxNoListServiceImpl.getById(id);
      if(uptaxNoList != null){
        uptaxNoList = ObjectCopyUtils.copyProperties(taxNoList,uptaxNoList,true);
      }
      return XfR.ok(taxNoListServiceImpl.updateById(uptaxNoList));
  }

  /**
   * 通过id删除税号清单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxnolists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxNoListServiceImpl.removeById(id));
  }

  @PostMapping("/taxnolists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_no_list");
     params.put("request", condition);

     return XfR.ok(taxNoListServiceImpl.querys(params));
  }

}
