package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.BillTaxUsage;
import com.xforceplus.financialsettlement.service.IBillTaxUsageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-14
 */
@RestController
public class BillTaxUsageController {

  @Autowired
  private IBillTaxUsageService billTaxUsageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billTaxUsage ${table.comment}
   * @return
   */
  @GetMapping("/billtaxusages" )
  public XfR getBillTaxUsages(XfPage page, BillTaxUsage billTaxUsage) {
    return XfR.ok(billTaxUsageServiceImpl.page(page, Wrappers.query(billTaxUsage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billtaxusages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billTaxUsageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billTaxUsage ${table.comment}
   * @return XfR
   */
  @PostMapping("/billtaxusages")
  public XfR save(@RequestBody BillTaxUsage billTaxUsage) {
     return XfR.ok(billTaxUsageServiceImpl.save(billTaxUsage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billTaxUsage ${table.comment}
   * @return XfR
   */
  @PutMapping("/billtaxusages/{id}")
  public XfR putUpdate(@RequestBody BillTaxUsage billTaxUsage,@PathVariable Long id) {
      billTaxUsage.setId(id);
      return XfR.ok(billTaxUsageServiceImpl.updateById(billTaxUsage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billTaxUsage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billtaxusages/{id}")
  public XfR patchUpdate(@RequestBody BillTaxUsage billTaxUsage,@PathVariable Long id) {
      BillTaxUsage upbillTaxUsage = billTaxUsageServiceImpl.getById(id);
      if(upbillTaxUsage != null){
        upbillTaxUsage = ObjectCopyUtils.copyProperties(billTaxUsage,upbillTaxUsage,true);
      }
      return XfR.ok(billTaxUsageServiceImpl.updateById(upbillTaxUsage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billtaxusages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billTaxUsageServiceImpl.removeById(id));
  }

  @PostMapping("/billtaxusages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_tax_usage");
     params.put("request", condition);

     return XfR.ok(billTaxUsageServiceImpl.querys(params));
  }

}
