package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FinancialKeeperChangeBill;
import com.xforceplus.financialsettlement.service.IFinancialKeeperChangeBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 保管人变更申请单前端控制器
 *
 * @author ultraman
 * @date 2022-09-14
 */
@RestController
public class FinancialKeeperChangeBillController {

  @Autowired
  private IFinancialKeeperChangeBillService financialKeeperChangeBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return
   */
  @GetMapping("/financialkeeperchangebills" )
  public XfR getFinancialKeeperChangeBills(XfPage page, FinancialKeeperChangeBill financialKeeperChangeBill) {
    return XfR.ok(financialKeeperChangeBillServiceImpl.page(page, Wrappers.query(financialKeeperChangeBill)));
  }

  /**
   * 通过id查询保管人变更申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/financialkeeperchangebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(financialKeeperChangeBillServiceImpl.getById(id));
  }

  /**
   * 新增保管人变更申请单
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return XfR
   */
  @PostMapping("/financialkeeperchangebills")
  public XfR save(@RequestBody FinancialKeeperChangeBill financialKeeperChangeBill) {
     return XfR.ok(financialKeeperChangeBillServiceImpl.save(financialKeeperChangeBill));
  }

  /**
   * 修改-传入修改后的全部数据保管人变更申请单
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return XfR
   */
  @PutMapping("/financialkeeperchangebills/{id}")
  public XfR putUpdate(@RequestBody FinancialKeeperChangeBill financialKeeperChangeBill,@PathVariable Long id) {
      financialKeeperChangeBill.setId(id);
      return XfR.ok(financialKeeperChangeBillServiceImpl.updateById(financialKeeperChangeBill));
  }

  /**
   * 修改-传入修改的数据保管人变更申请单
   * @param financialKeeperChangeBill 保管人变更申请单
   * @return XfR
   */
  @PatchMapping("/financialkeeperchangebills/{id}")
  public XfR patchUpdate(@RequestBody FinancialKeeperChangeBill financialKeeperChangeBill,@PathVariable Long id) {
      FinancialKeeperChangeBill upfinancialKeeperChangeBill = financialKeeperChangeBillServiceImpl.getById(id);
      if(upfinancialKeeperChangeBill != null){
        upfinancialKeeperChangeBill = ObjectCopyUtils.copyProperties(financialKeeperChangeBill,upfinancialKeeperChangeBill,true);
      }
      return XfR.ok(financialKeeperChangeBillServiceImpl.updateById(upfinancialKeeperChangeBill));
  }

  /**
   * 通过id删除保管人变更申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/financialkeeperchangebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(financialKeeperChangeBillServiceImpl.removeById(id));
  }

  @PostMapping("/financialkeeperchangebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "financial_keeper_change_bill");
     params.put("request", condition);

     return XfR.ok(financialKeeperChangeBillServiceImpl.querys(params));
  }

}
