package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.FkjBillRelation;
import com.xforceplus.financialsettlement.service.IFkjBillRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-14
 */
@RestController
public class FkjBillRelationController {

  @Autowired
  private IFkjBillRelationService fkjBillRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fkjBillRelation ${table.comment}
   * @return
   */
  @GetMapping("/fkjbillrelations" )
  public XfR getFkjBillRelations(XfPage page, FkjBillRelation fkjBillRelation) {
    return XfR.ok(fkjBillRelationServiceImpl.page(page, Wrappers.query(fkjBillRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fkjbillrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fkjBillRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fkjBillRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/fkjbillrelations")
  public XfR save(@RequestBody FkjBillRelation fkjBillRelation) {
     return XfR.ok(fkjBillRelationServiceImpl.save(fkjBillRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fkjBillRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/fkjbillrelations/{id}")
  public XfR putUpdate(@RequestBody FkjBillRelation fkjBillRelation,@PathVariable Long id) {
      fkjBillRelation.setId(id);
      return XfR.ok(fkjBillRelationServiceImpl.updateById(fkjBillRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fkjBillRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fkjbillrelations/{id}")
  public XfR patchUpdate(@RequestBody FkjBillRelation fkjBillRelation,@PathVariable Long id) {
      FkjBillRelation upfkjBillRelation = fkjBillRelationServiceImpl.getById(id);
      if(upfkjBillRelation != null){
        upfkjBillRelation = ObjectCopyUtils.copyProperties(fkjBillRelation,upfkjBillRelation,true);
      }
      return XfR.ok(fkjBillRelationServiceImpl.updateById(upfkjBillRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fkjbillrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fkjBillRelationServiceImpl.removeById(id));
  }

  @PostMapping("/fkjbillrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fkj_bill_relation");
     params.put("request", condition);

     return XfR.ok(fkjBillRelationServiceImpl.querys(params));
  }

}
