package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderProjectItemBind;
import com.xforceplus.financialsettlement.service.IOrderProjectItemBindService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-14
 */
@RestController
public class OrderProjectItemBindController {

  @Autowired
  private IOrderProjectItemBindService orderProjectItemBindServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderProjectItemBind ${table.comment}
   * @return
   */
  @GetMapping("/orderprojectitembinds" )
  public XfR getOrderProjectItemBinds(XfPage page, OrderProjectItemBind orderProjectItemBind) {
    return XfR.ok(orderProjectItemBindServiceImpl.page(page, Wrappers.query(orderProjectItemBind)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderprojectitembinds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderProjectItemBindServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderProjectItemBind ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderprojectitembinds")
  public XfR save(@RequestBody OrderProjectItemBind orderProjectItemBind) {
     return XfR.ok(orderProjectItemBindServiceImpl.save(orderProjectItemBind));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderProjectItemBind ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderprojectitembinds/{id}")
  public XfR putUpdate(@RequestBody OrderProjectItemBind orderProjectItemBind,@PathVariable Long id) {
      orderProjectItemBind.setId(id);
      return XfR.ok(orderProjectItemBindServiceImpl.updateById(orderProjectItemBind));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderProjectItemBind ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderprojectitembinds/{id}")
  public XfR patchUpdate(@RequestBody OrderProjectItemBind orderProjectItemBind,@PathVariable Long id) {
      OrderProjectItemBind uporderProjectItemBind = orderProjectItemBindServiceImpl.getById(id);
      if(uporderProjectItemBind != null){
        uporderProjectItemBind = ObjectCopyUtils.copyProperties(orderProjectItemBind,uporderProjectItemBind,true);
      }
      return XfR.ok(orderProjectItemBindServiceImpl.updateById(uporderProjectItemBind));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderprojectitembinds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderProjectItemBindServiceImpl.removeById(id));
  }

  @PostMapping("/orderprojectitembinds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_project_item_bind");
     params.put("request", condition);

     return XfR.ok(orderProjectItemBindServiceImpl.querys(params));
  }

}
