package com.xforceplus.financialsettlement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ProductAllocation;
import com.xforceplus.financialsettlement.service.IProductAllocationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中台分摊记录前端控制器
 *
 * @author ultraman
 * @date 2022-09-14
 */
@RestController
public class ProductAllocationController {

  @Autowired
  private IProductAllocationService productAllocationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param productAllocation 中台分摊记录
   * @return
   */
  @GetMapping("/productallocations" )
  public XfR getProductAllocations(XfPage page, ProductAllocation productAllocation) {
    return XfR.ok(productAllocationServiceImpl.page(page, Wrappers.query(productAllocation)));
  }

  /**
   * 通过id查询中台分摊记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/productallocations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(productAllocationServiceImpl.getById(id));
  }

  /**
   * 新增中台分摊记录
   * @param productAllocation 中台分摊记录
   * @return XfR
   */
  @PostMapping("/productallocations")
  public XfR save(@RequestBody ProductAllocation productAllocation) {
     return XfR.ok(productAllocationServiceImpl.save(productAllocation));
  }

  /**
   * 修改-传入修改后的全部数据中台分摊记录
   * @param productAllocation 中台分摊记录
   * @return XfR
   */
  @PutMapping("/productallocations/{id}")
  public XfR putUpdate(@RequestBody ProductAllocation productAllocation,@PathVariable Long id) {
      productAllocation.setId(id);
      return XfR.ok(productAllocationServiceImpl.updateById(productAllocation));
  }

  /**
   * 修改-传入修改的数据中台分摊记录
   * @param productAllocation 中台分摊记录
   * @return XfR
   */
  @PatchMapping("/productallocations/{id}")
  public XfR patchUpdate(@RequestBody ProductAllocation productAllocation,@PathVariable Long id) {
      ProductAllocation upproductAllocation = productAllocationServiceImpl.getById(id);
      if(upproductAllocation != null){
        upproductAllocation = ObjectCopyUtils.copyProperties(productAllocation,upproductAllocation,true);
      }
      return XfR.ok(productAllocationServiceImpl.updateById(upproductAllocation));
  }

  /**
   * 通过id删除中台分摊记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/productallocations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(productAllocationServiceImpl.removeById(id));
  }

  @PostMapping("/productallocations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "product_allocation");
     params.put("request", condition);

     return XfR.ok(productAllocationServiceImpl.querys(params));
  }

}
